/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.stubs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ksp.com.intellij.diagnostic.PluginException;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.LanguageParserDefinitions;
import ksp.com.intellij.lang.ParserDefinition;
import ksp.com.intellij.lang.TreeBackedLighterAST;
import ksp.com.intellij.openapi.diagnostic.ControlFlowException;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.fileTypes.LanguageFileType;
import ksp.com.intellij.openapi.roots.impl.PushedFilePropertiesRetriever;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.util.Pair;
import ksp.com.intellij.openapi.util.ThrowableComputable;
import ksp.com.intellij.openapi.util.Trinity;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.FileViewProvider;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.StubBuilder;
import ksp.com.intellij.psi.impl.source.PsiFileImpl;
import ksp.com.intellij.psi.stubs.BinaryFileStubBuilder;
import ksp.com.intellij.psi.stubs.BinaryFileStubBuilders;
import ksp.com.intellij.psi.stubs.LightStubBuilder;
import ksp.com.intellij.psi.stubs.PsiFileStub;
import ksp.com.intellij.psi.stubs.PsiFileStubImpl;
import ksp.com.intellij.psi.stubs.Stub;
import ksp.com.intellij.psi.stubs.StubBase;
import ksp.com.intellij.psi.stubs.StubBuilderType;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.psi.tree.IFileElementType;
import ksp.com.intellij.psi.tree.IStubFileElementType;
import ksp.com.intellij.util.ExceptionUtil;
import ksp.com.intellij.util.SmartList;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.com.intellij.util.indexing.FileContent;
import ksp.com.intellij.util.indexing.IndexedFile;
import ksp.com.intellij.util.indexing.IndexingDataKeys;
import ksp.com.intellij.util.indexing.PsiDependentFileContent;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class StubTreeBuilder {
    private static final Logger LOG = Logger.getInstance(StubTreeBuilder.class);
    private static final Key<Stub> stubElementKey = Key.create("stub.tree.for.file.content");

    private StubTreeBuilder() {
    }

    static boolean requiresContentToFindBuilder(@NotNull FileType fileType) {
        if (fileType == null) {
            StubTreeBuilder.$$$reportNull$$$0(0);
        }
        BinaryFileStubBuilder builder2 = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
        return builder2 instanceof BinaryFileStubBuilder.CompositeBinaryFileStubBuilder;
    }

    static StubBuilderType getStubBuilderType(@NotNull IndexedFile file2, boolean toBuild) {
        FileType fileType;
        BinaryFileStubBuilder builder2;
        if (file2 == null) {
            StubTreeBuilder.$$$reportNull$$$0(1);
        }
        if ((builder2 = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType = file2.getFileType())) != null) {
            if (builder2 instanceof BinaryFileStubBuilder.CompositeBinaryFileStubBuilder) {
                Object subBuilder = ((BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)builder2).getSubBuilder((FileContent)file2);
                return new StubBuilderType((BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)builder2, subBuilder);
            }
            return new StubBuilderType(builder2);
        }
        if (fileType instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
            if (parserDefinition == null) {
                return null;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            if (!(elementType instanceof IStubFileElementType)) {
                return null;
            }
            VirtualFile vFile = file2.getFile();
            boolean shouldBuildStubFor = ((IStubFileElementType)elementType).shouldBuildStubFor(vFile);
            if (toBuild && !shouldBuildStubFor) {
                return null;
            }
            PushedFilePropertiesRetriever pushedFilePropertiesRetriever = PushedFilePropertiesRetriever.getInstance();
            @NotNull List<String> properties = pushedFilePropertiesRetriever != null ? pushedFilePropertiesRetriever.dumpSortedPushedProperties(vFile) : Collections.emptyList();
            return new StubBuilderType((IStubFileElementType)elementType, properties);
        }
        return null;
    }

    @Nullable
    public static Stub buildStubTree(@NotNull FileContent inputData) {
        StubBuilderType type2;
        if (inputData == null) {
            StubTreeBuilder.$$$reportNull$$$0(2);
        }
        if ((type2 = StubTreeBuilder.getStubBuilderType(inputData, false)) == null) {
            return null;
        }
        return StubTreeBuilder.buildStubTree(inputData, type2);
    }

    @Nullable
    private static <T> T handleStubBuilderException(@NotNull FileContent inputData, @NotNull StubBuilderType stubBuilderType, @NotNull ThrowableComputable<T, Exception> builder2) {
        if (inputData == null) {
            StubTreeBuilder.$$$reportNull$$$0(3);
        }
        if (stubBuilderType == null) {
            StubTreeBuilder.$$$reportNull$$$0(4);
        }
        if (builder2 == null) {
            StubTreeBuilder.$$$reportNull$$$0(5);
        }
        try {
            return builder2.compute();
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                ExceptionUtil.rethrowUnchecked(e);
            }
            LOG.error(PluginException.createByClass("Failed to build stub tree for " + inputData.getFileName(), e, stubBuilderType.getClassToBlameInCaseOfException()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Stub buildStubTree(@NotNull FileContent inputData, @NotNull StubBuilderType stubBuilderType) {
        Stub data;
        if (inputData == null) {
            StubTreeBuilder.$$$reportNull$$$0(6);
        }
        if (stubBuilderType == null) {
            StubTreeBuilder.$$$reportNull$$$0(7);
        }
        if ((data = inputData.getUserData(stubElementKey)) != null) {
            return data;
        }
        FileContent fileContent = inputData;
        synchronized (fileContent) {
            data = inputData.getUserData(stubElementKey);
            if (data != null) {
                return data;
            }
            BinaryFileStubBuilder builder2 = stubBuilderType.getBinaryFileStubBuilder();
            if (builder2 != null) {
                data = StubTreeBuilder.handleStubBuilderException(inputData, stubBuilderType, () -> builder2.buildStubTree(inputData));
                if (data instanceof PsiFileStubImpl && !((PsiFileStubImpl)data).rootsAreSet()) {
                    ((PsiFileStubImpl)data).setStubRoots(new PsiFileStub[]{(PsiFileStubImpl)data});
                }
            } else {
                CharSequence contentAsText = inputData.getContentAsText();
                PsiDependentFileContent fileContent2 = (PsiDependentFileContent)inputData;
                PsiFile psi = fileContent2.getPsiFile();
                FileViewProvider viewProvider = psi.getViewProvider();
                psi = viewProvider.getStubBindingRoot();
                psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, contentAsText);
                psi.getManager().startBatchFilesProcessingMode();
                try {
                    IStubFileElementType<?> stubFileElementType = ((PsiFileImpl)psi).getElementTypeForStubBuilder();
                    if (stubFileElementType != null) {
                        PsiFileStub[] stubsArray;
                        StubBuilder stubBuilder = stubFileElementType.getBuilder();
                        if (stubBuilder instanceof LightStubBuilder) {
                            LightStubBuilder.FORCED_AST.set(fileContent2.getLighterAST());
                        }
                        PsiFile finalPsi = psi;
                        data = StubTreeBuilder.handleStubBuilderException(inputData, stubBuilderType, () -> stubBuilder.buildStubTree(finalPsi));
                        List<Pair<IStubFileElementType, PsiFile>> stubbedRoots = StubTreeBuilder.getStubbedRoots(viewProvider);
                        ArrayList<PsiFileStub> stubs = new ArrayList<PsiFileStub>(stubbedRoots.size());
                        stubs.add((PsiFileStub)data);
                        for (Pair<IStubFileElementType, PsiFile> stubbedRoot : stubbedRoots) {
                            StubElement element2;
                            PsiFile secondaryPsi = (PsiFile)stubbedRoot.second;
                            if (psi == secondaryPsi) continue;
                            StubBuilder stubbedRootBuilder = ((IStubFileElementType)stubbedRoot.first).getBuilder();
                            if (stubbedRootBuilder instanceof LightStubBuilder) {
                                LightStubBuilder.FORCED_AST.set(new TreeBackedLighterAST(secondaryPsi.getNode()));
                            }
                            if ((element2 = StubTreeBuilder.handleStubBuilderException(inputData, stubBuilderType, () -> stubbedRootBuilder.buildStubTree(secondaryPsi))) instanceof PsiFileStub) {
                                stubs.add((PsiFileStub)element2);
                            }
                            StubTreeBuilder.ensureNormalizedOrder(element2);
                        }
                        for (PsiFileStub stub : stubsArray = stubs.toArray(PsiFileStub.EMPTY_ARRAY)) {
                            if (!(stub instanceof PsiFileStubImpl)) continue;
                            ((PsiFileStubImpl)stub).setStubRoots(stubsArray);
                        }
                    }
                }
                finally {
                    psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, null);
                    psi.getManager().finishBatchFilesProcessingMode();
                }
            }
            StubTreeBuilder.ensureNormalizedOrder(data);
            inputData.putUserData(stubElementKey, data);
            return data;
        }
    }

    private static void ensureNormalizedOrder(Stub element2) {
        if (element2 instanceof StubBase) {
            ((StubBase)element2).myStubList.finalizeLoadingStage();
        }
    }

    @NotNull
    public static List<Pair<IStubFileElementType, PsiFile>> getStubbedRoots(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            StubTreeBuilder.$$$reportNull$$$0(8);
        }
        SmartList roots = new SmartList();
        PsiFile stubBindingRoot = viewProvider.getStubBindingRoot();
        for (Language language : viewProvider.getLanguages()) {
            IStubFileElementType<?> type2;
            PsiFile file2 = viewProvider.getPsi(language);
            if (!(file2 instanceof PsiFileImpl) || (type2 = ((PsiFileImpl)file2).getElementTypeForStubBuilder()) == null) continue;
            roots.add(Trinity.create(language, type2, file2));
        }
        ContainerUtil.sort(roots, (o1, o2) -> {
            if (o1.third == stubBindingRoot) {
                return o2.third == stubBindingRoot ? 0 : -1;
            }
            if (o2.third == stubBindingRoot) {
                return 1;
            }
            return StringUtil.compare(((Language)o1.first).getID(), ((Language)o2.first).getID(), false);
        });
        List<Pair<IStubFileElementType, PsiFile>> list = ContainerUtil.map(roots, trinity -> Pair.create((IStubFileElementType)trinity.second, (PsiFile)trinity.third));
        if (list == null) {
            StubTreeBuilder.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubBuilderType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/stubs/StubTreeBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/stubs/StubTreeBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "requiresContentToFindBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStubBuilderType";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleStubBuilderException";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStubbedRoots";
                break;
            }
            case 9: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

