/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.model;

import ksp.com.intellij.model.ModelBranch;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.util.ObjectUtils;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class ModelBranchUtil {
    private ModelBranchUtil() {
    }

    @NotNull
    public static <T extends PsiElement> T obtainCopyFromTheSameBranch(@NotNull PsiElement context2, @NotNull T element2) {
        ModelBranch branch;
        if (context2 == null) {
            ModelBranchUtil.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            ModelBranchUtil.$$$reportNull$$$0(1);
        }
        if ((branch = ModelBranch.getPsiBranch(context2)) == null) {
            T t = element2;
            if (t == null) {
                ModelBranchUtil.$$$reportNull$$$0(2);
            }
            return t;
        }
        ModelBranch elementBranch = ModelBranch.getPsiBranch(element2);
        if (elementBranch == branch) {
            T t = element2;
            if (t == null) {
                ModelBranchUtil.$$$reportNull$$$0(3);
            }
            return t;
        }
        if (elementBranch != null) {
            throw new IllegalArgumentException("Branch of supplied element differs from context branch");
        }
        T t = branch.obtainPsiCopy(element2);
        if (t == null) {
            ModelBranchUtil.$$$reportNull$$$0(4);
        }
        return t;
    }

    @NotNull
    public static VirtualFile obtainCopyFromTheSameBranch(@NotNull VirtualFile context2, @NotNull VirtualFile file2) {
        ModelBranch branch;
        if (context2 == null) {
            ModelBranchUtil.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            ModelBranchUtil.$$$reportNull$$$0(6);
        }
        if ((branch = ModelBranch.getFileBranch(context2)) == null) {
            VirtualFile virtualFile = file2;
            if (virtualFile == null) {
                ModelBranchUtil.$$$reportNull$$$0(7);
            }
            return virtualFile;
        }
        ModelBranch fileBranch = ModelBranch.getFileBranch(file2);
        if (fileBranch == branch) {
            VirtualFile virtualFile = file2;
            if (virtualFile == null) {
                ModelBranchUtil.$$$reportNull$$$0(8);
            }
            return virtualFile;
        }
        if (fileBranch != null) {
            throw new IllegalArgumentException("Branch of supplied file differs from context branch");
        }
        VirtualFile virtualFile = branch.findFileCopy(file2);
        if (virtualFile == null) {
            ModelBranchUtil.$$$reportNull$$$0(9);
        }
        return virtualFile;
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile findOriginalFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        ModelBranch branch = ModelBranch.getFileBranch(file2);
        return branch == null ? file2 : branch.findOriginalFile(file2);
    }

    @Contract(value="null -> null")
    @Nullable
    public static <T extends PsiElement> T findOriginalPsi(@Nullable T psi) {
        if (psi == null) {
            return null;
        }
        ModelBranch branch = ModelBranch.getPsiBranch(psi);
        return branch == null ? psi : branch.findOriginalPsi(psi);
    }

    @Nullable
    public static <T> T getAndResetCopyableUserData(PsiElement element2, Key<T> key) {
        ModelBranch branch = ModelBranch.getPsiBranch(element2);
        PsiElement original = branch == null ? null : branch.findOriginalPsi(element2);
        T data = ObjectUtils.notNull(original, element2).getCopyableUserData(key);
        if (data != null) {
            if (original != null) {
                branch.runAfterMerge(() -> original.putCopyableUserData(key, null));
            } else {
                element2.putCopyableUserData(key, null);
            }
        }
        return data;
    }

    public static void checkSameBranch(@NotNull VirtualFile left, @NotNull VirtualFile right) {
        ModelBranch rightBranch;
        ModelBranch leftBranch;
        if (left == null) {
            ModelBranchUtil.$$$reportNull$$$0(10);
        }
        if (right == null) {
            ModelBranchUtil.$$$reportNull$$$0(11);
        }
        if ((leftBranch = ModelBranch.getFileBranch(left)) != (rightBranch = ModelBranch.getFileBranch(right))) {
            throw new IllegalArgumentException("Files from different branches: " + leftBranch + " vs " + rightBranch);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/model/ModelBranchUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/model/ModelBranchUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainCopyFromTheSameBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "obtainCopyFromTheSameBranch";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkSameBranch";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

