/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.AggregatedElements;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.aggregateddeps.AggregatedDepsMetadata;
import dagger.hilt.processor.internal.root.AutoValue_ComponentTreeDepsMetadata;
import dagger.hilt.processor.internal.root.ir.ComponentTreeDepsIr;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;

@AutoValue
abstract class ComponentTreeDepsMetadata {
    ComponentTreeDepsMetadata() {
    }

    abstract ClassName name();

    abstract ImmutableSet<XTypeElement> aggregatedRootDeps();

    abstract ImmutableSet<XTypeElement> defineComponentDeps();

    abstract ImmutableSet<XTypeElement> aliasOfDeps();

    abstract ImmutableSet<XTypeElement> aggregatedDeps();

    abstract ImmutableSet<XTypeElement> aggregatedUninstallModulesDeps();

    abstract ImmutableSet<XTypeElement> aggregatedEarlyEntryPointDeps();

    static ComponentTreeDepsMetadata from(XTypeElement element, XProcessingEnv env) {
        Preconditions.checkArgument((boolean)element.hasAnnotation(ClassNames.COMPONENT_TREE_DEPS));
        XAnnotation annotation = element.getAnnotation(ClassNames.COMPONENT_TREE_DEPS);
        return ComponentTreeDepsMetadata.create(element.getClassName(), AggregatedElements.unwrapProxies((ImmutableCollection<XTypeElement>)XAnnotations.getAsTypeElementList((XAnnotation)annotation, (String)"rootDeps")), AggregatedElements.unwrapProxies((ImmutableCollection<XTypeElement>)XAnnotations.getAsTypeElementList((XAnnotation)annotation, (String)"defineComponentDeps")), AggregatedElements.unwrapProxies((ImmutableCollection<XTypeElement>)XAnnotations.getAsTypeElementList((XAnnotation)annotation, (String)"aliasOfDeps")), AggregatedElements.unwrapProxies((ImmutableCollection<XTypeElement>)XAnnotations.getAsTypeElementList((XAnnotation)annotation, (String)"aggregatedDeps")), AggregatedElements.unwrapProxies((ImmutableCollection<XTypeElement>)XAnnotations.getAsTypeElementList((XAnnotation)annotation, (String)"uninstallModulesDeps")), AggregatedElements.unwrapProxies((ImmutableCollection<XTypeElement>)XAnnotations.getAsTypeElementList((XAnnotation)annotation, (String)"earlyEntryPointDeps")));
    }

    static ComponentTreeDepsMetadata from(ComponentTreeDepsIr ir, XProcessingEnv env) {
        return ComponentTreeDepsMetadata.create(ir.getName(), (ImmutableSet<XTypeElement>)((ImmutableSet)ir.getRootDeps().stream().map(it -> env.requireTypeElement(it.canonicalName())).collect(DaggerStreams.toImmutableSet())), (ImmutableSet<XTypeElement>)((ImmutableSet)ir.getDefineComponentDeps().stream().map(it -> env.requireTypeElement(it.canonicalName())).collect(DaggerStreams.toImmutableSet())), (ImmutableSet<XTypeElement>)((ImmutableSet)ir.getAliasOfDeps().stream().map(it -> env.requireTypeElement(it.canonicalName())).collect(DaggerStreams.toImmutableSet())), (ImmutableSet<XTypeElement>)((ImmutableSet)ir.getAggregatedDeps().stream().map(it -> env.requireTypeElement(it.canonicalName())).collect(DaggerStreams.toImmutableSet())), (ImmutableSet<XTypeElement>)((ImmutableSet)ir.getUninstallModulesDeps().stream().map(it -> env.requireTypeElement(it.canonicalName())).collect(DaggerStreams.toImmutableSet())), (ImmutableSet<XTypeElement>)((ImmutableSet)ir.getEarlyEntryPointDeps().stream().map(it -> env.requireTypeElement(it.canonicalName())).collect(DaggerStreams.toImmutableSet())));
    }

    public ImmutableSet<XTypeElement> modules() {
        return (ImmutableSet)AggregatedDepsMetadata.from(this.aggregatedDeps()).stream().filter(AggregatedDepsMetadata::isModule).map(AggregatedDepsMetadata::dependency).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<XTypeElement> entrypoints() {
        return (ImmutableSet)AggregatedDepsMetadata.from(this.aggregatedDeps()).stream().filter(dependency -> !dependency.isModule()).map(AggregatedDepsMetadata::dependency).collect(DaggerStreams.toImmutableSet());
    }

    static ComponentTreeDepsMetadata create(ClassName name, ImmutableSet<XTypeElement> aggregatedRootDeps, ImmutableSet<XTypeElement> defineComponentDeps, ImmutableSet<XTypeElement> aliasOfDeps, ImmutableSet<XTypeElement> aggregatedDeps, ImmutableSet<XTypeElement> aggregatedUninstallModulesDeps, ImmutableSet<XTypeElement> aggregatedEarlyEntryPointDeps) {
        return new AutoValue_ComponentTreeDepsMetadata(name, aggregatedRootDeps, defineComponentDeps, aliasOfDeps, aggregatedDeps, aggregatedUninstallModulesDeps, aggregatedEarlyEntryPointDeps);
    }
}

