/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.definecomponent;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import dagger.hilt.processor.internal.AggregatedElements;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.definecomponent.AutoValue_DefineComponentClassesMetadata;
import dagger.hilt.processor.internal.root.ir.DefineComponentClassesIr;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;

@AutoValue
public abstract class DefineComponentClassesMetadata {
    public abstract XTypeElement aggregatingElement();

    public abstract XTypeElement element();

    abstract boolean isComponent();

    boolean isComponentBuilder() {
        return !this.isComponent();
    }

    public static ImmutableSet<DefineComponentClassesMetadata> from(XProcessingEnv env) {
        return DefineComponentClassesMetadata.from(AggregatedElements.from("dagger.hilt.processor.internal.definecomponent.codegen", ClassNames.DEFINE_COMPONENT_CLASSES, env));
    }

    public static ImmutableSet<DefineComponentClassesMetadata> from(ImmutableSet<XTypeElement> aggregatedElements) {
        return (ImmutableSet)aggregatedElements.stream().map(aggregatedElement -> DefineComponentClassesMetadata.create(aggregatedElement)).collect(DaggerStreams.toImmutableSet());
    }

    private static DefineComponentClassesMetadata create(XTypeElement element) {
        XAnnotation annotation = element.getAnnotation(ClassNames.DEFINE_COMPONENT_CLASSES);
        String componentName = annotation.getAsString("component");
        String builderName = annotation.getAsString("builder");
        ProcessorErrors.checkState(!componentName.isEmpty() || !builderName.isEmpty(), (XElement)element, (Object)"@DefineComponentClasses missing both `component` and `builder` members.");
        ProcessorErrors.checkState(componentName.isEmpty() || builderName.isEmpty(), (XElement)element, (Object)"@DefineComponentClasses should not include both `component` and `builder` members.");
        boolean isComponent = !componentName.isEmpty();
        String componentOrBuilderName = isComponent ? componentName : builderName;
        XTypeElement componentOrBuilderElement = XConverters.getProcessingEnv((XElement)element).findTypeElement(componentOrBuilderName);
        ProcessorErrors.checkState(componentOrBuilderElement != null, (XElement)componentOrBuilderElement, "%s.%s(), has invalid value: `%s`.", ClassNames.DEFINE_COMPONENT_CLASSES.simpleName(), isComponent ? "component" : "builder", componentOrBuilderName);
        return new AutoValue_DefineComponentClassesMetadata(element, componentOrBuilderElement, isComponent);
    }

    public static DefineComponentClassesIr toIr(DefineComponentClassesMetadata metadata) {
        return new DefineComponentClassesIr(metadata.aggregatingElement().getClassName(), metadata.element().getClassName().canonicalName());
    }
}

