/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.aggregateddeps;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.Processors;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Optional;

final class AggregatedDepsGenerator {
    static final String AGGREGATING_PACKAGE = "hilt_aggregated_deps";
    private static final ClassName AGGREGATED_DEPS = ClassName.get((String)"dagger.hilt.processor.internal.aggregateddeps", (String)"AggregatedDeps", (String[])new String[0]);
    private final String dependencyType;
    private final XTypeElement dependency;
    private final Optional<ClassName> testName;
    private final ImmutableSet<ClassName> components;
    private final ImmutableSet<ClassName> replacedDependencies;

    AggregatedDepsGenerator(String dependencyType, XTypeElement dependency, Optional<ClassName> testName, ImmutableSet<ClassName> components, ImmutableSet<ClassName> replacedDependencies) {
        this.dependencyType = dependencyType;
        this.dependency = dependency;
        this.testName = testName;
        this.components = components;
        this.replacedDependencies = replacedDependencies;
    }

    void generate() {
        Processors.generateAggregatingClass(AGGREGATING_PACKAGE, this.aggregatedDepsAnnotation(), this.dependency, this.getClass());
    }

    private AnnotationSpec aggregatedDepsAnnotation() {
        AnnotationSpec.Builder annotationBuilder = AnnotationSpec.builder((ClassName)AGGREGATED_DEPS);
        this.components.forEach(component -> annotationBuilder.addMember("components", "$S", new Object[]{component}));
        this.replacedDependencies.forEach(dep -> annotationBuilder.addMember("replaces", "$S", new Object[]{dep}));
        this.testName.ifPresent(test -> annotationBuilder.addMember("test", "$S", new Object[]{test}));
        annotationBuilder.addMember(this.dependencyType, "$S", new Object[]{this.dependency.getQualifiedName()});
        return annotationBuilder.build();
    }
}

