/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.lifecycle;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.AbstractSavedStateViewModelFactory;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.savedstate.SavedStateRegistryOwner;
import dagger.Module;
import dagger.hilt.EntryPoint;
import dagger.hilt.EntryPoints;
import dagger.hilt.InstallIn;
import dagger.hilt.android.components.ViewModelComponent;
import dagger.hilt.android.internal.builders.ViewModelComponentBuilder;
import dagger.hilt.android.internal.lifecycle.HiltViewModelMap;
import dagger.multibindings.Multibinds;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;

public final class HiltViewModelFactory
implements ViewModelProvider.Factory {
    private final Set<String> viewModelInjectKeys;
    private final ViewModelProvider.Factory delegateFactory;
    private final AbstractSavedStateViewModelFactory viewModelInjectFactory;

    public HiltViewModelFactory(@NonNull SavedStateRegistryOwner owner, @Nullable Bundle defaultArgs, @NonNull Set<String> viewModelInjectKeys, @NonNull ViewModelProvider.Factory delegateFactory, final @NonNull ViewModelComponentBuilder viewModelComponentBuilder) {
        this.viewModelInjectKeys = viewModelInjectKeys;
        this.delegateFactory = delegateFactory;
        this.viewModelInjectFactory = new AbstractSavedStateViewModelFactory(owner, defaultArgs){

            @NonNull
            protected <T extends ViewModel> T create(@NonNull String key, @NonNull Class<T> modelClass, @NonNull SavedStateHandle handle) {
                ViewModelComponent component = viewModelComponentBuilder.savedStateHandle(handle).build();
                Provider<ViewModel> provider = ((ViewModelFactoriesEntryPoint)EntryPoints.get((Object)component, ViewModelFactoriesEntryPoint.class)).getHiltViewModelMap().get(modelClass.getName());
                if (provider == null) {
                    throw new IllegalStateException("Expected the @ViewModelInject-annotated class '" + modelClass.getName() + "' to be available in the multi-binding of @ViewModelInjectMap but none was found.");
                }
                return (T)((ViewModel)provider.get());
            }
        };
    }

    @NonNull
    public <T extends ViewModel> T create(@NonNull Class<T> modelClass) {
        if (this.viewModelInjectKeys.contains(modelClass.getName())) {
            return (T)this.viewModelInjectFactory.create(modelClass);
        }
        return (T)this.delegateFactory.create(modelClass);
    }

    @Module
    @InstallIn(value={ViewModelComponent.class})
    static interface ViewModelModule {
        @Multibinds
        @HiltViewModelMap
        public Map<String, ViewModel> hiltViewModelMap();
    }

    @EntryPoint
    @InstallIn(value={ViewModelComponent.class})
    static interface ViewModelFactoriesEntryPoint {
        @HiltViewModelMap
        public Map<String, Provider<ViewModel>> getHiltViewModelMap();
    }
}

