/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.lifecycle;

import androidx.activity.ComponentActivity;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import dagger.Module;
import dagger.hilt.EntryPoint;
import dagger.hilt.EntryPoints;
import dagger.hilt.InstallIn;
import dagger.hilt.android.components.ActivityComponent;
import dagger.hilt.android.components.FragmentComponent;
import dagger.hilt.android.internal.lifecycle.DefaultActivityViewModelFactory;
import dagger.hilt.android.internal.lifecycle.DefaultFragmentViewModelFactory;
import dagger.multibindings.Multibinds;
import java.util.Set;

public final class DefaultViewModelFactories {
    @Nullable
    public static ViewModelProvider.Factory getActivityFactory(ComponentActivity activity) {
        return DefaultViewModelFactories.getFactoryFromSet(((ActivityEntryPoint)EntryPoints.get((Object)activity, ActivityEntryPoint.class)).getActivityViewModelFactory());
    }

    @Nullable
    public static ViewModelProvider.Factory getFragmentFactory(Fragment fragment) {
        return DefaultViewModelFactories.getFactoryFromSet(((FragmentEntryPoint)EntryPoints.get((Object)fragment, FragmentEntryPoint.class)).getFragmentViewModelFactory());
    }

    @Nullable
    private static ViewModelProvider.Factory getFactoryFromSet(Set<ViewModelProvider.Factory> set) {
        if (set.isEmpty()) {
            return null;
        }
        if (set.size() > 1) {
            throw new IllegalStateException("At most one default view model factory is expected. Found " + set);
        }
        ViewModelProvider.Factory factory = set.iterator().next();
        if (factory == null) {
            throw new IllegalStateException("Default view model factory must not be null.");
        }
        return factory;
    }

    private DefaultViewModelFactories() {
    }

    @EntryPoint
    @InstallIn(value={FragmentComponent.class})
    public static interface FragmentEntryPoint {
        @DefaultFragmentViewModelFactory
        public Set<ViewModelProvider.Factory> getFragmentViewModelFactory();
    }

    @Module
    @InstallIn(value={FragmentComponent.class})
    public static interface FragmentModule {
        @Multibinds
        @DefaultFragmentViewModelFactory
        public Set<ViewModelProvider.Factory> defaultViewModelFactory();
    }

    @EntryPoint
    @InstallIn(value={ActivityComponent.class})
    public static interface ActivityEntryPoint {
        @DefaultActivityViewModelFactory
        public Set<ViewModelProvider.Factory> getActivityViewModelFactory();
    }

    @Module
    @InstallIn(value={ActivityComponent.class})
    public static interface ActivityModule {
        @Multibinds
        @DefaultActivityViewModelFactory
        public Set<ViewModelProvider.Factory> defaultViewModelFactory();
    }
}

