/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.auto.value.AutoValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.root.AutoValue_TestRootMetadata;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Optional;
import java.util.Set;

@AutoValue
abstract class TestRootMetadata {
    TestRootMetadata() {
    }

    abstract XTypeElement testElement();

    abstract XTypeElement baseElement();

    ClassName testName() {
        return this.testElement().getClassName();
    }

    ClassName baseAppName() {
        return this.baseElement().getClassName();
    }

    ClassName appName() {
        return Processors.append(Processors.getEnclosedClassName(this.testName()), "_Application");
    }

    ClassName testInjectorName() {
        return Processors.append(Processors.getEnclosedClassName(this.testName()), "_GeneratedInjector");
    }

    Optional<XAnnotation> skipTestInjectionAnnotation() {
        XAnnotation skipTestAnnotation = this.testElement().getAnnotation(ClassNames.SKIP_TEST_INJECTION);
        if (skipTestAnnotation != null) {
            return Optional.of(skipTestAnnotation);
        }
        Set annotatedAnnotations = this.testElement().getAnnotationsAnnotatedWith(ClassNames.SKIP_TEST_INJECTION);
        if (!annotatedAnnotations.isEmpty()) {
            return Optional.of((XAnnotation)annotatedAnnotations.iterator().next());
        }
        return Optional.empty();
    }

    static TestRootMetadata of(XProcessingEnv env, XElement element) {
        XTypeElement testElement = XElements.asTypeElement((XElement)element);
        XTypeElement baseElement = env.requireTypeElement((TypeName)ClassNames.MULTI_DEX_APPLICATION);
        ProcessorErrors.checkState(!element.hasAnnotation(ClassNames.ANDROID_ENTRY_POINT), element, (Object)"Tests cannot be annotated with @AndroidEntryPoint. Please use @HiltAndroidTest");
        ProcessorErrors.checkState(element.hasAnnotation(ClassNames.HILT_ANDROID_TEST), element, (Object)"Tests must be annotated with @HiltAndroidTest");
        return new AutoValue_TestRootMetadata(testElement, baseElement);
    }
}

