/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.customtestapplication;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.processor.internal.customtestapplication.AutoValue_CustomTestApplicationMetadata;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;

@AutoValue
abstract class CustomTestApplicationMetadata {
    CustomTestApplicationMetadata() {
    }

    abstract XTypeElement element();

    abstract ClassName baseAppName();

    ClassName appName() {
        return Processors.append(Processors.getEnclosedClassName(this.element().getClassName()), "_Application");
    }

    static CustomTestApplicationMetadata of(XElement element) {
        Preconditions.checkState((boolean)element.hasAnnotation(ClassNames.CUSTOM_TEST_APPLICATION), (String)"The given element, %s, is not annotated with @%s.", (Object)XElements.toStableString((XElement)element), (Object)ClassNames.CUSTOM_TEST_APPLICATION.simpleName());
        ProcessorErrors.checkState(XElementKt.isTypeElement((XElement)element), element, "@%s should only be used on classes or interfaces but found: %s", ClassNames.CUSTOM_TEST_APPLICATION.simpleName(), XElements.toStableString((XElement)element));
        XTypeElement baseAppElement = CustomTestApplicationMetadata.getBaseElement(element);
        return new AutoValue_CustomTestApplicationMetadata(XElements.asTypeElement((XElement)element), baseAppElement.getClassName());
    }

    private static XTypeElement getBaseElement(XElement element) {
        XTypeElement baseElement;
        XTypeElement baseSuperclassElement = baseElement = element.getAnnotation(ClassNames.CUSTOM_TEST_APPLICATION).getAsType("value").getTypeElement();
        while (baseSuperclassElement.getSuperClass() != null) {
            ProcessorErrors.checkState(!baseSuperclassElement.hasAnnotation(ClassNames.HILT_ANDROID_APP), element, "@%s value cannot be annotated with @%s. Found: %s", ClassNames.CUSTOM_TEST_APPLICATION.simpleName(), ClassNames.HILT_ANDROID_APP.simpleName(), baseSuperclassElement.getClassName());
            ImmutableList injectFields = (ImmutableList)baseSuperclassElement.getDeclaredFields().stream().filter(field -> field.hasAnnotation(ClassNames.INJECT)).collect(DaggerStreams.toImmutableList());
            ProcessorErrors.checkState(injectFields.isEmpty(), element, "@%s does not support application classes (or super classes) with @Inject fields. Found %s with @Inject fields %s.", ClassNames.CUSTOM_TEST_APPLICATION.simpleName(), baseSuperclassElement.getClassName(), injectFields.stream().map(XElements::toStableString).collect(DaggerStreams.toImmutableList()));
            ImmutableList injectMethods = (ImmutableList)baseSuperclassElement.getDeclaredMethods().stream().filter(method -> method.hasAnnotation(ClassNames.INJECT)).collect(DaggerStreams.toImmutableList());
            ProcessorErrors.checkState(injectMethods.isEmpty(), element, "@%s does not support application classes (or super classes) with @Inject methods. Found %s with @Inject methods %s.", ClassNames.CUSTOM_TEST_APPLICATION.simpleName(), baseSuperclassElement.getClassName(), injectMethods.stream().map(XElements::toStableString).collect(DaggerStreams.toImmutableList()));
            ImmutableList injectConstructors = (ImmutableList)baseSuperclassElement.getConstructors().stream().filter(method -> method.hasAnnotation(ClassNames.INJECT)).collect(DaggerStreams.toImmutableList());
            ProcessorErrors.checkState(injectConstructors.isEmpty(), element, "@%s does not support application classes (or super classes) with @Inject constructors. Found %s with @Inject constructors %s.", ClassNames.CUSTOM_TEST_APPLICATION.simpleName(), baseSuperclassElement.getClassName().canonicalName(), injectConstructors.stream().map(XElements::toStableString).collect(DaggerStreams.toImmutableList()));
            baseSuperclassElement = baseSuperclassElement.getSuperClass().getTypeElement();
        }
        ProcessorErrors.checkState(Processors.isAssignableFrom(baseElement, ClassNames.APPLICATION), element, "@%s value should be an instance of %s. Found: %s", ClassNames.CUSTOM_TEST_APPLICATION.simpleName(), ClassNames.APPLICATION, baseElement.getClassName());
        return baseElement;
    }
}

