/*
 * Decompiled with CFR 0.152.
 */
package dagger.spi.internal.shaded.com.google.auto.common;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class MoreStreams {
    public static <T> Collector<T, ?, ImmutableList<T>> toImmutableList() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf);
    }

    public static <T> Collector<T, ?, ImmutableSet<T>> toImmutableSet() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableSet::copyOf);
    }

    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(Function<? super T, K> keyMapper, Function<? super T, V> valueMapper) {
        return Collectors.mapping(value2 -> Maps.immutableEntry(keyMapper.apply(value2), valueMapper.apply(value2)), Collector.of(ImmutableMap::builder, (builder, entry) -> builder.put(entry), (left, right) -> left.putAll((Map)right.build()), ImmutableMap.Builder::build, new Collector.Characteristics[0]));
    }

    public static <T, K, V> Collector<T, ?, ImmutableBiMap<K, V>> toImmutableBiMap(Function<? super T, K> keyMapper, Function<? super T, V> valueMapper) {
        return Collectors.mapping(value2 -> Maps.immutableEntry(keyMapper.apply(value2), valueMapper.apply(value2)), Collector.of(ImmutableBiMap::builder, (builder, entry) -> builder.put(entry), (left, right) -> left.putAll((Map)right.build()), ImmutableBiMap.Builder::build, new Collector.Characteristics[0]));
    }

    private MoreStreams() {
    }
}

