/*
 * Decompiled with CFR 0.152.
 */
package dagger.spi.internal.shaded.com.google.auto.common;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import dagger.spi.internal.shaded.com.google.auto.common.AnnotationMirrors;
import dagger.spi.internal.shaded.com.google.auto.common.AnnotationOutput;
import dagger.spi.internal.shaded.com.google.auto.common.MoreStreams;
import dagger.spi.internal.shaded.com.google.auto.common.MoreTypes;
import java.util.List;
import java.util.function.Function;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

public final class AnnotationValues {
    private static final Equivalence<AnnotationValue> ANNOTATION_VALUE_EQUIVALENCE = new Equivalence<AnnotationValue>(){

        protected boolean doEquivalent(AnnotationValue left, AnnotationValue right) {
            return left.accept(new SimpleAnnotationValueVisitor8<Boolean, AnnotationValue>(this){

                @Override
                protected Boolean defaultAction(Object left, AnnotationValue right) {
                    return left.equals(right.accept(new SimpleAnnotationValueVisitor8<Object, Void>(this){

                        @Override
                        protected Object defaultAction(Object object, Void unused) {
                            return object;
                        }
                    }, null));
                }

                @Override
                public Boolean visitAnnotation(AnnotationMirror left, AnnotationValue right) {
                    return right.accept(new SimpleAnnotationValueVisitor8<Boolean, AnnotationMirror>(this){

                        @Override
                        protected Boolean defaultAction(Object right, AnnotationMirror left) {
                            return false;
                        }

                        @Override
                        public Boolean visitAnnotation(AnnotationMirror right, AnnotationMirror left) {
                            return AnnotationMirrors.equivalence().equivalent((Object)left, (Object)right);
                        }
                    }, left);
                }

                @Override
                public Boolean visitArray(List<? extends AnnotationValue> left, AnnotationValue right) {
                    return right.accept(new SimpleAnnotationValueVisitor8<Boolean, List<? extends AnnotationValue>>(this){

                        @Override
                        protected Boolean defaultAction(Object ignored, List<? extends AnnotationValue> alsoIgnored) {
                            return false;
                        }

                        @Override
                        public Boolean visitArray(List<? extends AnnotationValue> right, List<? extends AnnotationValue> left) {
                            return AnnotationValues.equivalence().pairwise().equivalent(left, right);
                        }
                    }, left);
                }

                @Override
                public Boolean visitType(TypeMirror left, AnnotationValue right) {
                    return right.accept(new SimpleAnnotationValueVisitor8<Boolean, TypeMirror>(this){

                        @Override
                        protected Boolean defaultAction(Object ignored, TypeMirror alsoIgnored) {
                            return false;
                        }

                        @Override
                        public Boolean visitType(TypeMirror right, TypeMirror left) {
                            return MoreTypes.equivalence().equivalent((Object)left, (Object)right);
                        }
                    }, left);
                }
            }, right);
        }

        protected int doHash(AnnotationValue value2) {
            return value2.accept(new SimpleAnnotationValueVisitor8<Integer, Void>(this){

                @Override
                public Integer visitAnnotation(AnnotationMirror value2, Void ignore) {
                    return AnnotationMirrors.equivalence().hash((Object)value2);
                }

                @Override
                public Integer visitArray(List<? extends AnnotationValue> values, Void ignore) {
                    return AnnotationValues.equivalence().pairwise().hash(values);
                }

                @Override
                public Integer visitType(TypeMirror value2, Void ignore) {
                    return MoreTypes.equivalence().hash((Object)value2);
                }

                @Override
                protected Integer defaultAction(Object value2, Void ignored) {
                    return value2.hashCode();
                }
            }, null);
        }
    };
    private static final ArrayVisitor<DeclaredType> TYPE_MIRRORS_VISITOR = new ArrayVisitor<DeclaredType>(AnnotationValues::getTypeMirror);
    private static final ArrayVisitor<AnnotationMirror> ANNOTATION_MIRRORS_VISITOR = new ArrayVisitor<AnnotationMirror>(AnnotationValues::getAnnotationMirror);
    private static final ArrayVisitor<VariableElement> ENUMS_VISITOR = new ArrayVisitor<VariableElement>(AnnotationValues::getEnum);
    private static final ArrayVisitor<String> STRINGS_VISITOR = new ArrayVisitor<String>(AnnotationValues::getString);
    private static final ArrayVisitor<Integer> INTS_VISITOR = new ArrayVisitor<Integer>(AnnotationValues::getInt);
    private static final ArrayVisitor<Long> LONGS_VISITOR = new ArrayVisitor<Long>(AnnotationValues::getLong);
    private static final ArrayVisitor<Byte> BYTES_VISITOR = new ArrayVisitor<Byte>(AnnotationValues::getByte);
    private static final ArrayVisitor<Short> SHORTS_VISITOR = new ArrayVisitor<Short>(AnnotationValues::getShort);
    private static final ArrayVisitor<Float> FLOATS_VISITOR = new ArrayVisitor<Float>(AnnotationValues::getFloat);
    private static final ArrayVisitor<Double> DOUBLES_VISITOR = new ArrayVisitor<Double>(AnnotationValues::getDouble);
    private static final ArrayVisitor<Boolean> BOOLEANS_VISITOR = new ArrayVisitor<Boolean>(AnnotationValues::getBoolean);
    private static final ArrayVisitor<Character> CHARS_VISITOR = new ArrayVisitor<Character>(AnnotationValues::getChar);
    private static final ArrayVisitor<AnnotationValue> ANNOTATION_VALUES_VISITOR = new ArrayVisitor<AnnotationValue>(x -> x);

    public static Equivalence<AnnotationValue> equivalence() {
        return ANNOTATION_VALUE_EQUIVALENCE;
    }

    public static DeclaredType getTypeMirror(AnnotationValue value2) {
        return (DeclaredType)TypeMirrorVisitor.INSTANCE.visit(value2);
    }

    public static AnnotationMirror getAnnotationMirror(AnnotationValue value2) {
        return (AnnotationMirror)AnnotationMirrorVisitor.INSTANCE.visit(value2);
    }

    public static VariableElement getEnum(AnnotationValue value2) {
        return (VariableElement)EnumVisitor.INSTANCE.visit(value2);
    }

    private static <T> T valueOfType(AnnotationValue annotationValue, Class<T> type2) {
        Object value2 = annotationValue.getValue();
        if (!type2.isInstance(value2)) {
            String string = type2.getSimpleName();
            String string2 = String.valueOf(value2);
            throw new IllegalArgumentException(new StringBuilder(24 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Expected ").append(string).append(", got instead: ").append(string2).toString());
        }
        return type2.cast(value2);
    }

    public static String getString(AnnotationValue value2) {
        return AnnotationValues.valueOfType(value2, String.class);
    }

    public static int getInt(AnnotationValue value2) {
        return AnnotationValues.valueOfType(value2, Integer.class);
    }

    public static long getLong(AnnotationValue value2) {
        return AnnotationValues.valueOfType(value2, Long.class);
    }

    public static byte getByte(AnnotationValue value2) {
        return AnnotationValues.valueOfType(value2, Byte.class);
    }

    public static short getShort(AnnotationValue value2) {
        return AnnotationValues.valueOfType(value2, Short.class);
    }

    public static float getFloat(AnnotationValue value2) {
        return AnnotationValues.valueOfType(value2, Float.class).floatValue();
    }

    public static double getDouble(AnnotationValue value2) {
        return AnnotationValues.valueOfType(value2, Double.class);
    }

    public static boolean getBoolean(AnnotationValue value2) {
        return AnnotationValues.valueOfType(value2, Boolean.class);
    }

    public static char getChar(AnnotationValue value2) {
        return AnnotationValues.valueOfType(value2, Character.class).charValue();
    }

    public static ImmutableList<DeclaredType> getTypeMirrors(AnnotationValue value2) {
        return (ImmutableList)TYPE_MIRRORS_VISITOR.visit(value2);
    }

    public static ImmutableList<AnnotationMirror> getAnnotationMirrors(AnnotationValue value2) {
        return (ImmutableList)ANNOTATION_MIRRORS_VISITOR.visit(value2);
    }

    public static ImmutableList<VariableElement> getEnums(AnnotationValue value2) {
        return (ImmutableList)ENUMS_VISITOR.visit(value2);
    }

    public static ImmutableList<String> getStrings(AnnotationValue value2) {
        return (ImmutableList)STRINGS_VISITOR.visit(value2);
    }

    public static ImmutableList<Integer> getInts(AnnotationValue value2) {
        return (ImmutableList)INTS_VISITOR.visit(value2);
    }

    public static ImmutableList<Long> getLongs(AnnotationValue value2) {
        return (ImmutableList)LONGS_VISITOR.visit(value2);
    }

    public static ImmutableList<Byte> getBytes(AnnotationValue value2) {
        return (ImmutableList)BYTES_VISITOR.visit(value2);
    }

    public static ImmutableList<Short> getShorts(AnnotationValue value2) {
        return (ImmutableList)SHORTS_VISITOR.visit(value2);
    }

    public static ImmutableList<Float> getFloats(AnnotationValue value2) {
        return (ImmutableList)FLOATS_VISITOR.visit(value2);
    }

    public static ImmutableList<Double> getDoubles(AnnotationValue value2) {
        return (ImmutableList)DOUBLES_VISITOR.visit(value2);
    }

    public static ImmutableList<Boolean> getBooleans(AnnotationValue value2) {
        return (ImmutableList)BOOLEANS_VISITOR.visit(value2);
    }

    public static ImmutableList<Character> getChars(AnnotationValue value2) {
        return (ImmutableList)CHARS_VISITOR.visit(value2);
    }

    public static ImmutableList<AnnotationValue> getAnnotationValues(AnnotationValue value2) {
        return (ImmutableList)ANNOTATION_VALUES_VISITOR.visit(value2);
    }

    public static String toString(AnnotationValue annotationValue) {
        return AnnotationOutput.toString(annotationValue);
    }

    private AnnotationValues() {
    }

    private static final class ArrayVisitor<T>
    extends SimpleAnnotationValueVisitor8<ImmutableList<T>, Void> {
        final Function<AnnotationValue, T> visitT;

        ArrayVisitor(Function<AnnotationValue, T> visitT) {
            this.visitT = (Function)Preconditions.checkNotNull(visitT);
        }

        @Override
        public ImmutableList<T> defaultAction(Object o, Void unused) {
            String string = String.valueOf(o);
            throw new IllegalStateException(new StringBuilder(32 + String.valueOf(string).length()).append("Expected an array, got instead: ").append(string).toString());
        }

        @Override
        public ImmutableList<T> visitArray(List<? extends AnnotationValue> values, Void unused) {
            return values.stream().map(this.visitT).collect(MoreStreams.toImmutableList());
        }
    }

    private static final class EnumVisitor
    extends DefaultVisitor<VariableElement> {
        static final EnumVisitor INSTANCE = new EnumVisitor();

        EnumVisitor() {
            super(VariableElement.class);
        }

        @Override
        public VariableElement visitEnumConstant(VariableElement value2, Void unused) {
            return value2;
        }
    }

    private static final class AnnotationMirrorVisitor
    extends DefaultVisitor<AnnotationMirror> {
        static final AnnotationMirrorVisitor INSTANCE = new AnnotationMirrorVisitor();

        AnnotationMirrorVisitor() {
            super(AnnotationMirror.class);
        }

        @Override
        public AnnotationMirror visitAnnotation(AnnotationMirror value2, Void unused) {
            return value2;
        }
    }

    private static final class TypeMirrorVisitor
    extends DefaultVisitor<DeclaredType> {
        static final TypeMirrorVisitor INSTANCE = new TypeMirrorVisitor();

        TypeMirrorVisitor() {
            super(DeclaredType.class);
        }

        @Override
        public DeclaredType visitType(TypeMirror value2, Void unused) {
            return MoreTypes.asDeclared(value2);
        }
    }

    private static class DefaultVisitor<T>
    extends SimpleAnnotationValueVisitor8<T, Void> {
        final Class<T> clazz;

        DefaultVisitor(Class<T> clazz) {
            this.clazz = (Class)Preconditions.checkNotNull(clazz);
        }

        @Override
        public T defaultAction(Object o, Void unused) {
            String string = this.clazz.getSimpleName();
            String string2 = String.valueOf(o);
            throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Expected a ").append(string).append(", got instead: ").append(string2).toString());
        }
    }
}

