/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.extension;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;

public final class Optionals {
    public static <C extends Comparable<C>> Comparator<Optional<C>> optionalComparator() {
        return Comparator.comparing(optional -> optional.isPresent()).thenComparing(Optional::get);
    }

    public static <T> Comparator<Optional<T>> emptiesLast(Comparator<? super T> valueComparator) {
        Preconditions.checkNotNull(valueComparator);
        return Comparator.comparing(o -> o.orElse(null), Comparator.nullsLast(valueComparator));
    }

    @SafeVarargs
    public static <T> Optional<T> firstPresent(Optional<T> first, Optional<T> second, Optional<T> ... rest) {
        return Lists.asList(first, second, (Object[])rest).stream().filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public static <T> T rootmostValue(T start, Function<T, Optional<T>> nextFunction) {
        T current = start;
        Optional<T> next = nextFunction.apply(start);
        while (next.isPresent()) {
            current = next.get();
            next = nextFunction.apply(current);
        }
        return current;
    }

    private Optionals() {
    }
}

