/*
 * Decompiled with CFR 0.152.
 */
package dagger.spi.model;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Joiner;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import dagger.spi.model.;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.DaggerType;
import dagger.spi.model.MoreAnnotationMirrors;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

@AutoValue
public abstract class Key {
    public abstract Optional<DaggerAnnotation> qualifier();

    public abstract DaggerType type();

    public abstract Optional<MultibindingContributionIdentifier> multibindingContributionIdentifier();

    public abstract Builder toBuilder();

    @Memoized
    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public final String toString() {
        return Joiner.on((char)' ').skipNulls().join(this.qualifier().map(MoreAnnotationMirrors::toStableString).orElse(null), (Object)this.type(), new Object[]{this.multibindingContributionIdentifier().orElse(null)});
    }

    public static Builder builder(DaggerType type2) {
        return new .AutoValue_Key.Builder().type(type2);
    }

    public static final class MultibindingContributionIdentifier {
        private final String module;
        private final String bindingElement;

        @Deprecated
        public MultibindingContributionIdentifier(ExecutableElement bindingMethod, TypeElement contributingModule) {
            this(bindingMethod.getSimpleName().toString(), contributingModule.getQualifiedName().toString());
        }

        @Deprecated
        public MultibindingContributionIdentifier(String bindingElement, String module) {
            this.module = module;
            this.bindingElement = bindingElement;
        }

        @Deprecated
        public String module() {
            return this.module;
        }

        @Deprecated
        public String bindingElement() {
            return this.bindingElement;
        }

        public String toString() {
            return String.format("%s#%s", this.module, this.bindingElement);
        }

        public boolean equals(Object obj) {
            if (obj instanceof MultibindingContributionIdentifier) {
                MultibindingContributionIdentifier other = (MultibindingContributionIdentifier)obj;
                return this.module.equals(other.module) && this.bindingElement.equals(other.bindingElement);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.module, this.bindingElement);
        }
    }

    @CanIgnoreReturnValue
    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder type(DaggerType var1);

        public abstract Builder qualifier(Optional<DaggerAnnotation> var1);

        public abstract Builder qualifier(DaggerAnnotation var1);

        public abstract Builder multibindingContributionIdentifier(Optional<MultibindingContributionIdentifier> var1);

        public abstract Builder multibindingContributionIdentifier(MultibindingContributionIdentifier var1);

        @CheckReturnValue
        public abstract Key build();
    }
}

