/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.shaded.androidx.room.compiler.processing.XHasModifiers;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import kotlin.streams.jdk8.StreamsKt;

public final class XTypeElements {
    public static boolean isNested(XTypeElement typeElement2) {
        return typeElement2.getEnclosingTypeElement() != null;
    }

    public static boolean hasTypeParameters(XTypeElement type2) {
        return !XConverters.toJavac(type2).getTypeParameters().isEmpty();
    }

    public static ImmutableList<XMethodElement> getAllUnimplementedMethods(XTypeElement type2) {
        return StreamsKt.asStream(type2.getAllNonPrivateInstanceMethods()).filter(XHasModifiers::isAbstract).collect(DaggerStreams.toImmutableList());
    }

    public static boolean isEffectivelyPublic(XTypeElement element) {
        return XTypeElements.allVisibilities(element).stream().allMatch(visibility -> visibility.equals((Object)Visibility.PUBLIC));
    }

    public static boolean isEffectivelyPrivate(XTypeElement element) {
        return XTypeElements.allVisibilities(element).contains((Object)Visibility.PRIVATE);
    }

    private static ImmutableSet<Visibility> allVisibilities(XTypeElement element) {
        Preconditions.checkNotNull((Object)element);
        ImmutableSet.Builder visibilities = ImmutableSet.builder();
        for (XTypeElement currentElement = element; currentElement != null; currentElement = currentElement.getEnclosingTypeElement()) {
            visibilities.add((Object)Visibility.of(currentElement));
        }
        return visibilities.build();
    }

    private XTypeElements() {
    }

    private static enum Visibility {
        PUBLIC,
        PRIVATE,
        OTHER;


        private static Visibility of(XTypeElement element) {
            Preconditions.checkNotNull((Object)element);
            if (element.isPrivate()) {
                return PRIVATE;
            }
            if (element.isPublic()) {
                return PUBLIC;
            }
            return OTHER;
        }
    }
}

