/*
 * Decompiled with CFR 0.152.
 */
package dagger.model;

import com.google.common.collect.ForwardingObject;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.Network;
import dagger.internal.Preconditions;
import java.util.Optional;
import java.util.Set;

public class ForwardingNetwork<N, E>
extends ForwardingObject
implements Network<N, E> {
    private final Network<N, E> delegate;

    protected ForwardingNetwork(Network<N, E> delegate) {
        this.delegate = (Network)Preconditions.checkNotNull(delegate);
    }

    protected final Network<N, E> delegate() {
        return this.delegate;
    }

    public Set<N> nodes() {
        return this.delegate().nodes();
    }

    public Set<E> edges() {
        return this.delegate().edges();
    }

    public Graph<N> asGraph() {
        return this.delegate().asGraph();
    }

    public boolean isDirected() {
        return this.delegate().isDirected();
    }

    public boolean allowsParallelEdges() {
        return this.delegate().allowsParallelEdges();
    }

    public boolean allowsSelfLoops() {
        return this.delegate().allowsSelfLoops();
    }

    public ElementOrder<N> nodeOrder() {
        return this.delegate().nodeOrder();
    }

    public ElementOrder<E> edgeOrder() {
        return this.delegate().edgeOrder();
    }

    public Set<N> adjacentNodes(N node) {
        return this.delegate().adjacentNodes(node);
    }

    public Set<N> predecessors(N node) {
        return this.delegate().predecessors(node);
    }

    public Set<N> successors(N node) {
        return this.delegate().successors(node);
    }

    public Set<E> incidentEdges(N node) {
        return this.delegate().incidentEdges(node);
    }

    public Set<E> inEdges(N node) {
        return this.delegate().inEdges(node);
    }

    public Set<E> outEdges(N node) {
        return this.delegate().outEdges(node);
    }

    public int degree(N node) {
        return this.delegate().degree(node);
    }

    public int inDegree(N node) {
        return this.delegate().inDegree(node);
    }

    public int outDegree(N node) {
        return this.delegate().outDegree(node);
    }

    public EndpointPair<N> incidentNodes(E edge) {
        return this.delegate().incidentNodes(edge);
    }

    public Set<E> adjacentEdges(E edge) {
        return this.delegate().adjacentEdges(edge);
    }

    public Set<E> edgesConnecting(N nodeU, N nodeV) {
        return this.delegate().edgesConnecting(nodeU, nodeV);
    }

    public Optional<E> edgeConnecting(N nodeU, N nodeV) {
        return Optional.ofNullable(this.edgeConnectingOrNull(nodeU, nodeV));
    }

    public E edgeConnectingOrNull(N nodeU, N nodeV) {
        return (E)this.delegate().edgeConnectingOrNull(nodeU, nodeV);
    }

    public boolean hasEdgeConnecting(N nodeU, N nodeV) {
        return this.delegate().hasEdgeConnecting(nodeU, nodeV);
    }

    public boolean equals(Object obj) {
        return this.delegate().equals(obj);
    }

    public int hashCode() {
        return this.delegate().hashCode();
    }

    public String toString() {
        return this.delegate().toString();
    }
}

