/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import dagger.internal.DaggerCollections;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import dagger.producers.internal.Producers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;

public final class SetProducer<T>
extends AbstractProducer<Set<T>> {
    private static final Producer<Set<Object>> EMPTY_PRODUCER = Producers.immediateProducer(ImmutableSet.of());
    private final List<Producer<T>> individualProducers;
    private final List<Producer<Collection<T>>> collectionProducers;

    public static <T> Producer<Set<T>> empty() {
        return EMPTY_PRODUCER;
    }

    public static <T> Builder<T> builder(int individualProducerSize, int collectionProducerSize) {
        return new Builder(individualProducerSize, collectionProducerSize);
    }

    private SetProducer(List<Producer<T>> individualProducers, List<Producer<Collection<T>>> collectionProducers) {
        this.individualProducers = individualProducers;
        this.collectionProducers = collectionProducers;
    }

    @Override
    public ListenableFuture<Set<T>> compute() {
        ArrayList<Object> individualFutures = new ArrayList<Object>(this.individualProducers.size());
        for (Producer<T> producer : this.individualProducers) {
            individualFutures.add(Preconditions.checkNotNull(producer.get()));
        }
        ArrayList<Object> futureCollections = new ArrayList<Object>(this.collectionProducers.size() + 1);
        futureCollections.add(Futures.allAsList(individualFutures));
        for (Producer<Collection<T>> producer : this.collectionProducers) {
            futureCollections.add(Preconditions.checkNotNull(producer.get()));
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futureCollections), (Function)new Function<List<Collection<T>>, Set<T>>(){

            public Set<T> apply(List<Collection<T>> sets) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (Collection set : sets) {
                    builder.addAll(set);
                }
                return builder.build();
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public static final class Builder<T> {
        private final List<Producer<T>> individualProducers;
        private final List<Producer<Collection<T>>> collectionProducers;

        private Builder(int individualProducerSize, int collectionProducerSize) {
            this.individualProducers = DaggerCollections.presizedList((int)individualProducerSize);
            this.collectionProducers = DaggerCollections.presizedList((int)collectionProducerSize);
        }

        public Builder<T> addProducer(Producer<? extends T> individualProducer) {
            assert (individualProducer != null) : "Codegen error? Null producer";
            this.individualProducers.add(individualProducer);
            return this;
        }

        public Builder<T> addCollectionProducer(Producer<? extends Collection<? extends T>> multipleProducer) {
            assert (multipleProducer != null) : "Codegen error? Null producer";
            this.collectionProducers.add(multipleProducer);
            return this;
        }

        public SetProducer<T> build() {
            assert (!DaggerCollections.hasDuplicates(this.individualProducers)) : "Codegen error?  Duplicates in the producer list";
            assert (!DaggerCollections.hasDuplicates(this.collectionProducers)) : "Codegen error?  Duplicates in the producer list";
            return new SetProducer(this.individualProducers, this.collectionProducers);
        }
    }
}

