/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.ksp.symbol.KSAnnotated;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotated;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XEnumEntry;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XEnumTypeElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XFieldElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XHasModifiers;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMemberContainer;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeParameterElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XVariableElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.compat.XConverters;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

public final class XElements {
    public static String getSimpleName(XMemberContainer memberContainer) {
        return memberContainer.getClassName().simpleName();
    }

    public static String getSimpleName(XElement element) {
        if (XElementKt.isTypeElement(element)) {
            return XElements.asTypeElement(element).getName();
        }
        if (XElementKt.isVariableElement(element)) {
            return XElements.asVariable(element).getName();
        }
        if (XElements.isEnumEntry(element)) {
            return XElements.asEnumEntry(element).getName();
        }
        if (XElementKt.isMethod(element)) {
            return XElements.asMethod(element).getJvmName();
        }
        if (XElementKt.isConstructor(element)) {
            return "<init>";
        }
        if (XElements.isTypeParameter(element)) {
            return XElements.asTypeParameter(element).getName();
        }
        throw new AssertionError((Object)("No simple name for: " + element));
    }

    private static boolean isSyntheticElement(XElement element) {
        if (XElementKt.isMethodParameter(element)) {
            XExecutableParameterElement executableParam = XElements.asMethodParameter(element);
            return executableParam.isContinuationParam() || executableParam.isReceiverParam() || executableParam.isKotlinPropertyParam();
        }
        if (XElementKt.isMethod(element)) {
            return XElements.asMethod(element).isKotlinPropertyMethod();
        }
        return false;
    }

    @Nullable
    public static KSAnnotated toKSAnnotated(XElement element) {
        if (XElements.isSyntheticElement(element)) {
            return XConverters.toKS(element);
        }
        if (XElements.isExecutable(element)) {
            return XConverters.toKS(XElements.asExecutable(element));
        }
        if (XElementKt.isTypeElement(element)) {
            return XConverters.toKS(XElements.asTypeElement(element));
        }
        if (XElementKt.isField(element)) {
            return XConverters.toKS(XElements.asField(element));
        }
        if (XElementKt.isMethodParameter(element)) {
            return XConverters.toKS(XElements.asMethodParameter(element));
        }
        throw new IllegalStateException("Returning KSAnnotated declaration for " + element + " is not supported.");
    }

    public static XTypeElement closestEnclosingTypeElement(XElement element) {
        return XElements.optionalClosestEnclosingTypeElement(element).orElseThrow(() -> new IllegalStateException("No enclosing TypeElement for: " + element));
    }

    public static boolean transitivelyEncloses(XElement encloser, XElement enclosed) {
        for (XElement current = enclosed; current != null; current = current.getEnclosingElement()) {
            if (!current.equals(encloser)) continue;
            return true;
        }
        return false;
    }

    private static Optional<XTypeElement> optionalClosestEnclosingTypeElement(XElement element) {
        if (XElementKt.isTypeElement(element)) {
            return Optional.of(XElements.asTypeElement(element));
        }
        if (XElementKt.isConstructor(element)) {
            return Optional.of(XElements.asConstructor(element).getEnclosingElement());
        }
        if (XElementKt.isMethod(element)) {
            return XElements.optionalClosestEnclosingTypeElement(XElements.asMethod(element).getEnclosingElement());
        }
        if (XElementKt.isField(element)) {
            return XElements.optionalClosestEnclosingTypeElement(XElements.asField(element).getEnclosingElement());
        }
        if (XElementKt.isMethodParameter(element)) {
            return XElements.optionalClosestEnclosingTypeElement(XElements.asMethodParameter(element).getEnclosingElement());
        }
        return Optional.empty();
    }

    public static boolean isAbstract(XElement element) {
        return XElements.asHasModifiers(element).isAbstract();
    }

    public static boolean isPublic(XElement element) {
        return XElements.asHasModifiers(element).isPublic();
    }

    public static boolean isPrivate(XElement element) {
        return XElements.asHasModifiers(element).isPrivate();
    }

    public static boolean isInternal(XElement element) {
        return XElements.asHasModifiers(element).isInternal();
    }

    public static boolean isStatic(XElement element) {
        return XElements.asHasModifiers(element).isStatic();
    }

    private static XHasModifiers asHasModifiers(XElement element) {
        Preconditions.checkArgument((boolean)(element instanceof XHasModifiers), (String)"Element %s does not have modifiers", (Object)element);
        return (XHasModifiers)((Object)element);
    }

    public static boolean isPackage(XElement element) {
        if (XConverters.getProcessingEnv(element).getBackend() == XProcessingEnv.Backend.JAVAC) {
            Preconditions.checkState((XConverters.toJavac(element).getKind() != ElementKind.PACKAGE ? 1 : 0) != 0);
        }
        return false;
    }

    public static boolean isTypeParameter(XElement element) {
        return element instanceof XTypeParameterElement;
    }

    public static XTypeParameterElement asTypeParameter(XElement element) {
        return (XTypeParameterElement)element;
    }

    public static boolean isEnumEntry(XElement element) {
        return element instanceof XEnumEntry;
    }

    public static boolean isEnum(XElement element) {
        return element instanceof XEnumTypeElement;
    }

    public static boolean isExecutable(XElement element) {
        return XElementKt.isConstructor(element) || XElementKt.isMethod(element);
    }

    public static XExecutableElement asExecutable(XElement element) {
        Preconditions.checkState((boolean)XElements.isExecutable(element));
        return (XExecutableElement)element;
    }

    public static XTypeElement asTypeElement(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isTypeElement(element));
        return (XTypeElement)element;
    }

    public static XExecutableParameterElement asMethodParameter(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isMethodParameter(element));
        return (XExecutableParameterElement)element;
    }

    public static XFieldElement asField(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isField(element));
        return (XFieldElement)element;
    }

    public static XEnumEntry asEnumEntry(XElement element) {
        return (XEnumEntry)element;
    }

    public static XVariableElement asVariable(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isVariableElement(element));
        return (XVariableElement)element;
    }

    public static XConstructorElement asConstructor(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isConstructor(element));
        return (XConstructorElement)element;
    }

    public static XMethodElement asMethod(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isMethod(element));
        return (XMethodElement)element;
    }

    public static ImmutableSet<XAnnotation> getAnnotatedAnnotations(XAnnotated annotated, XClassName annotationName) {
        return (ImmutableSet)annotated.getAllAnnotations().stream().filter(annotation -> annotation.getType().getTypeElement().hasAnnotation(annotationName)).collect(DaggerStreams.toImmutableSet());
    }

    public static boolean hasAnyAnnotation(XAnnotated annotated, XClassName ... annotations) {
        return XElements.hasAnyAnnotation(annotated, (Collection<XClassName>)ImmutableSet.copyOf((Object[])annotations));
    }

    public static boolean hasAnyAnnotation(XAnnotated annotated, Collection<XClassName> annotations) {
        return annotations.stream().anyMatch(annotated::hasAnnotation);
    }

    public static Optional<XAnnotation> getAnyAnnotation(XAnnotated annotated, XClassName ... annotations) {
        return XElements.getAnyAnnotation(annotated, (Collection<XClassName>)ImmutableSet.copyOf((Object[])annotations));
    }

    public static Optional<XAnnotation> getAnyAnnotation(XAnnotated annotated, Collection<XClassName> annotations) {
        return annotations.stream().filter(annotated::hasAnnotation).map(annotated::getAnnotation).findFirst();
    }

    public static ImmutableSet<XAnnotation> getAllAnnotations(XAnnotated annotated, XClassName ... annotations) {
        return XElements.getAllAnnotations(annotated, (Collection<XClassName>)ImmutableSet.copyOf((Object[])annotations));
    }

    public static ImmutableSet<XAnnotation> getAllAnnotations(XAnnotated annotated, Collection<XClassName> annotations) {
        return (ImmutableSet)annotations.stream().filter(annotated::hasAnnotation).map(annotated::getAnnotation).collect(DaggerStreams.toImmutableSet());
    }

    public static String toStableString(XElement element) {
        if (element == null) {
            return "<null>";
        }
        try {
            if (XElementKt.isTypeElement(element)) {
                return XElements.asTypeElement(element).getQualifiedName();
            }
            if (XElements.isExecutable(element)) {
                XExecutableElement executable = XElements.asExecutable(element);
                boolean tooManyParameters = XConverters.getProcessingEnv(element).getBackend().equals((Object)XProcessingEnv.Backend.KSP) && executable.getParameters().size() > 10;
                return String.format("%s(%s)", XElements.getSimpleName(XElementKt.isConstructor(element) ? XElements.asConstructor(element).getEnclosingElement() : executable), (tooManyParameters ? executable.getParameters().stream().limit(10L) : executable.getParameters().stream().map(XVariableElement::getType).map(XTypes::toStableString).collect(Collectors.joining(","))) + (tooManyParameters ? ", ..." : ""));
            }
            if (XElements.isEnumEntry(element) || XElementKt.isField(element) || XElementKt.isMethodParameter(element) || XElements.isTypeParameter(element)) {
                return XElements.getSimpleName(element);
            }
            return element.toString();
        }
        catch (TypeNotPresentException e) {
            return e.typeName();
        }
    }

    public static String getKindName(XElement element) {
        if (XElementKt.isTypeElement(element)) {
            XTypeElement typeElement = XElements.asTypeElement(element);
            if (typeElement.isClass()) {
                return "CLASS";
            }
            if (typeElement.isInterface()) {
                return "INTERFACE";
            }
            if (typeElement.isAnnotationClass()) {
                return "ANNOTATION_TYPE";
            }
        } else {
            if (XElements.isEnum(element)) {
                return "ENUM";
            }
            if (XElements.isEnumEntry(element)) {
                return "ENUM_CONSTANT";
            }
            if (XElementKt.isConstructor(element)) {
                return "CONSTRUCTOR";
            }
            if (XElementKt.isMethod(element)) {
                return "METHOD";
            }
            if (XElementKt.isField(element)) {
                return "FIELD";
            }
            if (XElementKt.isMethodParameter(element)) {
                return "PARAMETER";
            }
            if (XElements.isTypeParameter(element)) {
                return "TYPE_PARAMETER";
            }
        }
        return element.kindName();
    }

    public static String packageName(XElement element) {
        return element.getClosestMemberContainer().asClassName().getPackageName();
    }

    public static boolean isFinal(XExecutableElement element) {
        if (element.isFinal()) {
            return true;
        }
        return XConverters.getProcessingEnv(element).getBackend() == XProcessingEnv.Backend.KSP && XConverters.toKS(element).getModifiers().contains(com.google.devtools.ksp.symbol.Modifier.FINAL);
    }

    public static ImmutableList<Modifier> getModifiers(XExecutableElement element) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (XElements.isFinal(element)) {
            builder.add((Object)Modifier.FINAL);
        } else if (element.isAbstract()) {
            builder.add((Object)Modifier.ABSTRACT);
        }
        if (element.isStatic()) {
            builder.add((Object)Modifier.STATIC);
        }
        if (element.isPublic()) {
            builder.add((Object)Modifier.PUBLIC);
        } else if (element.isPrivate()) {
            builder.add((Object)Modifier.PRIVATE);
        } else if (element.isProtected()) {
            builder.add((Object)Modifier.PROTECTED);
        }
        return builder.build();
    }

    private XElements() {
    }
}

