/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.internal.codegen.binding.MultiboundSetBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.MultibindingFactoryCreationExpression;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import java.util.Collection;
import javax.lang.model.element.Modifier;

final class SetFactoryCreationExpression
extends MultibindingFactoryCreationExpression {
    private final CompilerOptions compilerOptions;
    private final BindingGraph graph;
    private final MultiboundSetBinding binding;
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private String methodName;

    @AssistedInject
    SetFactoryCreationExpression(@Assisted MultiboundSetBinding binding, ComponentImplementation componentImplementation, ComponentRequestRepresentations componentRequestRepresentations, CompilerOptions compilerOptions, BindingGraph graph) {
        super(binding, componentImplementation, componentRequestRepresentations, compilerOptions);
        this.binding = (MultiboundSetBinding)Preconditions.checkNotNull((Object)binding);
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.compilerOptions = compilerOptions;
        this.graph = graph;
    }

    @Override
    public XCodeBlock creationExpression() {
        return XCodeBlock.of("%N(%L)", this.methodName(), XCodeBlocks.parameterNames(this.shardImplementation.constructorParameters()));
    }

    private String methodName() {
        if (this.methodName == null) {
            this.methodName = this.shardImplementation.getUniqueMethodName(KeyVariableNamer.name(this.binding.key()) + "Builder");
            UniqueNameSet uniqueNameSet = new UniqueNameSet();
            this.shardImplementation.constructorParameters().stream().map(XParameterSpec::getName).forEach(uniqueNameSet::claim);
            String builderName = uniqueNameSet.getUniqueName("builder");
            int individualProviders = 0;
            int setProviders = 0;
            XCodeBlock.Builder builderMethodCalls = XCodeBlock.builder();
            String methodNameSuffix = this.binding.bindingType().equals((Object)BindingType.PROVISION) ? "Provider" : "Producer";
            for (DependencyRequest dependency : this.binding.dependencies()) {
                String methodNamePrefix;
                XCodeBlock dependencyExpression = this.multibindingDependencyExpression(dependency);
                switch (this.graph.contributionBinding(dependency.key()).contributionType()) {
                    case SET: {
                        ++individualProviders;
                        methodNamePrefix = "add";
                        break;
                    }
                    case SET_VALUES: {
                        ++setProviders;
                        methodNamePrefix = "addCollection";
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)(dependency + " is not a set multibinding"));
                    }
                }
                builderMethodCalls.addStatement("%N.%N%N(%L)", builderName, methodNamePrefix, methodNameSuffix, dependencyExpression);
            }
            XFunSpec methodSpec = XFunSpecs.methodBuilder(this.methodName).addParameters((Collection<XParameterSpec>)this.shardImplementation.constructorParameters()).addModifiers((Collection<Modifier>)(!this.shardImplementation.isShardClassPrivate() ? ImmutableSet.of((Object)((Object)Modifier.PRIVATE)) : ImmutableSet.of())).returns(this.setFactoryType()).addCode(XCodeBlock.builder().addStatement("%T %N = %T.builder(%L, %L)", this.setFactoryBuilderType(), builderName, SourceFiles.setFactoryClassName(this.binding), individualProviders, setProviders).add(builderMethodCalls.build()).addStatement("return %N.build()", builderName).build()).build();
            this.shardImplementation.addMethod(ComponentImplementation.MethodSpecKind.INITIALIZE_HELPER_METHOD, methodSpec);
        }
        return this.methodName;
    }

    private XTypeName setFactoryType() {
        return this.useRawType() ? SourceFiles.setFactoryClassName(this.binding) : SourceFiles.setFactoryClassName(this.binding).parametrizedBy(this.valueTypeName());
    }

    private XTypeName setFactoryBuilderType() {
        return this.useRawType() ? SourceFiles.setFactoryClassName(this.binding).nestedClass("Builder") : SourceFiles.setFactoryClassName(this.binding).nestedClass("Builder").parametrizedBy(this.valueTypeName());
    }

    private XTypeName valueTypeName() {
        SetType setType = SetType.from(this.binding.key());
        return setType.elementsAreTypeOf(XTypeNames.PRODUCED) ? setType.unwrappedElementType(XTypeNames.PRODUCED).asTypeName() : setType.elementType().asTypeName();
    }

    @AssistedFactory
    static interface Factory {
        public SetFactoryCreationExpression create(MultiboundSetBinding var1);
    }
}

