/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.MethodRequestRepresentation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.internal.codegen.xprocessing.XExpressionType;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import java.util.Collection;
import javax.lang.model.element.Modifier;

final class PrivateMethodRequestRepresentation
extends MethodRequestRepresentation {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final ContributionBinding binding;
    private final BindingRequest request;
    private final RequestRepresentation wrappedRequestRepresentation;
    private final CompilerOptions compilerOptions;
    private final XProcessingEnv processingEnv;
    private String methodName;

    @AssistedInject
    PrivateMethodRequestRepresentation(@Assisted BindingRequest request, @Assisted ContributionBinding binding, @Assisted RequestRepresentation wrappedRequestRepresentation, ComponentImplementation componentImplementation, CompilerOptions compilerOptions, XProcessingEnv processingEnv) {
        super(componentImplementation.shardImplementation(binding), processingEnv);
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.request = (BindingRequest)Preconditions.checkNotNull((Object)request);
        this.wrappedRequestRepresentation = (RequestRepresentation)Preconditions.checkNotNull((Object)wrappedRequestRepresentation);
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.compilerOptions = compilerOptions;
        this.processingEnv = processingEnv;
    }

    @Override
    protected XCodeBlock methodCall() {
        return XCodeBlock.of("%N()", this.methodName());
    }

    @Override
    protected XExpressionType returnType() {
        String requestingPackage;
        XType type = this.request.isRequestKind(RequestKind.INSTANCE) && this.binding.contributedPrimitiveType().isPresent() ? this.binding.contributedPrimitiveType().get() : this.request.requestedType(this.binding.contributedType(), this.processingEnv);
        if (Accessibility.isTypeAccessibleFrom(type, requestingPackage = this.shardImplementation.name().getPackageName())) {
            return XExpressionType.create(type);
        }
        if (XTypes.isDeclared(type) && Accessibility.isRawTypeAccessible(type, requestingPackage)) {
            return XExpressionType.createRawType(type);
        }
        return XExpressionType.create(this.processingEnv.requireType(XTypeName.ANY_OBJECT));
    }

    private String methodName() {
        if (this.methodName == null) {
            this.methodName = this.shardImplementation.getUniqueMethodName(this.request);
            this.shardImplementation.addMethod(ComponentImplementation.MethodSpecKind.PRIVATE_METHOD, XFunSpecs.methodBuilder(this.methodName).addModifiers((Collection<Modifier>)(!this.shardImplementation.isShardClassPrivate() ? ImmutableSet.of((Object)((Object)Modifier.PRIVATE)) : ImmutableSet.of())).returns(this.returnType().asTypeName()).addStatement("return %L", this.wrappedRequestRepresentation.getDependencyExpression(this.shardImplementation.name()).codeBlock()).build());
        }
        return this.methodName;
    }

    @AssistedFactory
    static interface Factory {
        public PrivateMethodRequestRepresentation create(BindingRequest var1, ContributionBinding var2, RequestRepresentation var3);
    }
}

