/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequirementExpression;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.internal.codegen.writing.ModuleProxies;
import dagger.internal.codegen.writing.ParentComponent;
import dagger.internal.codegen.writing.PerComponentImplementation;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.NullableTypeNames;
import dagger.internal.codegen.xprocessing.XPropertySpecs;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

@PerComponentImplementation
public final class ComponentRequirementExpressions {
    private final Optional<ComponentRequirementExpressions> parent;
    private final Map<ComponentRequirement, ComponentRequirementExpression> componentRequirementExpressions = new HashMap<ComponentRequirement, ComponentRequirementExpression>();
    private final BindingGraph graph;
    private final ComponentImplementation.ShardImplementation componentShard;
    private final CompilerOptions compilerOptions;

    @Inject
    ComponentRequirementExpressions(@ParentComponent Optional<ComponentRequirementExpressions> parent, BindingGraph graph, ComponentImplementation componentImplementation, CompilerOptions compilerOptions) {
        this.parent = parent;
        this.graph = graph;
        this.componentShard = componentImplementation.getComponentShard();
        this.compilerOptions = compilerOptions;
    }

    XCodeBlock getExpression(ComponentRequirement componentRequirement, XClassName requestingClass) {
        return this.getExpression(componentRequirement).getExpression(requestingClass);
    }

    private ComponentRequirementExpression getExpression(ComponentRequirement componentRequirement) {
        if (this.graph.componentRequirements().contains((Object)componentRequirement)) {
            return this.componentRequirementExpressions.computeIfAbsent(componentRequirement, this::createExpression);
        }
        if (this.parent.isPresent()) {
            return this.parent.get().getExpression(componentRequirement);
        }
        throw new IllegalStateException("no component requirement expression found for " + componentRequirement);
    }

    XCodeBlock getExpressionDuringInitialization(ComponentRequirement componentRequirement, XClassName requestingClass) {
        return this.getExpression(componentRequirement).getExpressionDuringInitialization(requestingClass);
    }

    private ComponentRequirementExpression createExpression(ComponentRequirement requirement) {
        if (this.componentShard.componentDescriptor().hasCreator() || this.graph.factoryMethod().isPresent() && this.graph.factoryMethodParameters().containsKey((Object)requirement)) {
            return new ComponentParameterField(requirement);
        }
        if (requirement.kind().isModule()) {
            return new InstantiableModuleField(requirement);
        }
        throw new AssertionError((Object)String.format("Can't create %s in %s", requirement, this.componentShard.name()));
    }

    private final class ComponentParameterField
    extends AbstractField {
        private final String parameterName;

        ComponentParameterField(ComponentRequirement module) {
            super(module);
            this.parameterName = ComponentRequirementExpressions.this.componentShard.getParameterName(this.componentRequirement);
        }

        @Override
        public XCodeBlock getExpressionDuringInitialization(XClassName requestingClass) {
            if (ComponentRequirementExpressions.this.componentShard.name().equals(requestingClass)) {
                return XCodeBlock.of("%N", this.parameterName);
            }
            return this.getExpression(requestingClass);
        }

        @Override
        XCodeBlock fieldInitialization(XPropertySpec componentField) {
            return XCodeBlock.of("this.%N = %L;", componentField, this.parameterName);
        }
    }

    private final class InstantiableModuleField
    extends AbstractField {
        private final XTypeElement moduleElement;

        InstantiableModuleField(ComponentRequirement module) {
            super(module);
            Preconditions.checkArgument((boolean)module.kind().isModule());
            this.moduleElement = module.typeElement();
        }

        @Override
        XCodeBlock fieldInitialization(XPropertySpec componentField) {
            return XCodeBlock.of("this.%N = %L;", componentField, ModuleProxies.newModuleInstance(this.moduleElement, ComponentRequirementExpressions.this.componentShard.name()));
        }
    }

    private abstract class AbstractField
    implements ComponentRequirementExpression {
        final ComponentRequirement componentRequirement;
        private final Supplier<MemberSelect> field = Suppliers.memoize(this::createField);

        private AbstractField(ComponentRequirement componentRequirement) {
            this.componentRequirement = (ComponentRequirement)Preconditions.checkNotNull((Object)componentRequirement);
        }

        @Override
        public XCodeBlock getExpression(XClassName requestingClass) {
            return ((MemberSelect)this.field.get()).getExpressionFor(requestingClass);
        }

        private MemberSelect createField() {
            String fieldName = ComponentRequirementExpressions.this.componentShard.getUniqueFieldName(this.componentRequirement.variableName());
            Nullability nullability = this.componentRequirement.getNullability();
            XTypeName fieldType = NullableTypeNames.asNullableTypeName(this.componentRequirement.type().asTypeName(), nullability, ComponentRequirementExpressions.this.compilerOptions);
            XPropertySpec field = XPropertySpecs.builder(fieldName, fieldType, Modifier.PRIVATE, Modifier.FINAL).addAnnotationNames((Collection<XClassName>)nullability.nonTypeUseNullableAnnotations()).build();
            ComponentRequirementExpressions.this.componentShard.addField(ComponentImplementation.FieldSpecKind.COMPONENT_REQUIREMENT_FIELD, field);
            ComponentRequirementExpressions.this.componentShard.addComponentRequirementInitialization(this.fieldInitialization(field));
            return MemberSelect.localField(ComponentRequirementExpressions.this.componentShard, fieldName);
        }

        abstract XCodeBlock fieldInitialization(XPropertySpec var1);
    }
}

