/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.base.ValidationReport;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.MethodSignatureFormatter;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.Scope;
import dagger.internal.codegen.validation.AssistedValidator;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XMethodElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XFieldElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XVariableElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.tools.Diagnostic;

@Singleton
public final class InjectValidator
implements ClearableCache {
    private final XProcessingEnv processingEnv;
    private final DependencyRequestValidator dependencyRequestValidator;
    private final InjectionAnnotations injectionAnnotations;
    private final DaggerSuperficialValidation superficialValidation;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final InternalValidator validator;
    private final InternalValidator validatorWhenGeneratingCode;
    private final AssistedValidator assistedValidator;

    @Inject
    InjectValidator(XProcessingEnv processingEnv, DependencyRequestValidator dependencyRequestValidator, CompilerOptions compilerOptions, InjectionAnnotations injectionAnnotations, DaggerSuperficialValidation superficialValidation, MethodSignatureFormatter methodSignatureFormatter, AssistedValidator assistedValidator) {
        this.processingEnv = processingEnv;
        this.dependencyRequestValidator = dependencyRequestValidator;
        this.injectionAnnotations = injectionAnnotations;
        this.superficialValidation = superficialValidation;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.assistedValidator = assistedValidator;
        this.validatorWhenGeneratingCode = new InternalValidator(Diagnostic.Kind.ERROR, Diagnostic.Kind.ERROR);
        this.validator = compilerOptions.privateMemberValidationKind() == Diagnostic.Kind.ERROR && compilerOptions.staticMemberValidationKind() == Diagnostic.Kind.ERROR ? this.validatorWhenGeneratingCode : new InternalValidator(compilerOptions.privateMemberValidationKind(), compilerOptions.staticMemberValidationKind());
    }

    @Override
    public void clearCache() {
        this.validator.clearCache();
        this.validatorWhenGeneratingCode.clearCache();
    }

    public ValidationReport validate(XTypeElement typeElement) {
        return this.validator.validate(typeElement);
    }

    public ValidationReport validateForMembersInjection(XTypeElement typeElement) {
        return this.validator.validateForMembersInjection(typeElement);
    }

    public ValidationReport validateWhenGeneratingCode(XTypeElement typeElement) {
        if (typeElement.getPackageName().startsWith("org.atinject.tck")) {
            return this.validator.validate(typeElement);
        }
        return this.validatorWhenGeneratingCode.validate(typeElement);
    }

    private final class InternalValidator {
        private final Diagnostic.Kind privateMemberDiagnosticKind;
        private final Diagnostic.Kind staticMemberDiagnosticKind;
        private final Map<XTypeElement, ValidationReport> provisionReports = new HashMap<XTypeElement, ValidationReport>();
        private final Map<XTypeElement, ValidationReport> membersInjectionReports = new HashMap<XTypeElement, ValidationReport>();

        InternalValidator(Diagnostic.Kind privateMemberDiagnosticKind, Diagnostic.Kind staticMemberDiagnosticKind) {
            this.privateMemberDiagnosticKind = privateMemberDiagnosticKind;
            this.staticMemberDiagnosticKind = staticMemberDiagnosticKind;
        }

        void clearCache() {
            this.provisionReports.clear();
            this.membersInjectionReports.clear();
        }

        ValidationReport validate(XTypeElement typeElement) {
            return Util.reentrantComputeIfAbsent(this.provisionReports, typeElement, this::validateUncached);
        }

        private ValidationReport validateUncached(XTypeElement typeElement) {
            ValidationReport.Builder builder = ValidationReport.about(typeElement);
            builder.addSubreport(this.validateForMembersInjectionInternal(typeElement));
            ImmutableSet injectConstructors = ImmutableSet.builder().addAll(InjectionAnnotations.injectedConstructors(typeElement)).addAll(AssistedInjectionAnnotations.assistedInjectedConstructors(typeElement)).build();
            switch (injectConstructors.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    builder.addSubreport(this.validateConstructor((XConstructorElement)Iterables.getOnlyElement((Iterable)injectConstructors)));
                    break;
                }
                default: {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = typeElement.getQualifiedName();
                    objectArray[1] = injectConstructors.stream().map(InjectValidator.this.methodSignatureFormatter::format).collect(DaggerStreams.toImmutableList());
                    builder.addError(String.format("Type %s may only contain one injected constructor. Found: %s", objectArray), typeElement);
                }
            }
            return builder.build();
        }

        private ValidationReport validateConstructor(XConstructorElement constructorElement) {
            ValidationReport.Builder builder;
            block18: {
                ImmutableSet<Scope> scopes;
                XTypeElement enclosingElement;
                block17: {
                    String injectAnnotationName;
                    InjectValidator.this.superficialValidation.validateTypeOf(constructorElement);
                    builder = ValidationReport.about(constructorElement.getEnclosingElement());
                    boolean isInjectConstructor = InjectionAnnotations.hasInjectAnnotation(constructorElement);
                    boolean isAssistedInjectConstructor = InjectionAnnotations.hasAssistedInjectAnnotation(constructorElement);
                    if (isInjectConstructor && isAssistedInjectConstructor) {
                        builder.addError("Constructors cannot be annotated with both @Inject and @AssistedInject");
                        return builder.build();
                    }
                    if (isInjectConstructor) {
                        injectAnnotationName = "Inject";
                    } else if (isAssistedInjectConstructor) {
                        injectAnnotationName = "AssistedInject";
                    } else {
                        throw new AssertionError((Object)("No @Inject or @AssistedInject annotation found: " + constructorElement));
                    }
                    if (constructorElement.isPrivate()) {
                        builder.addError("Dagger does not support injection into private constructors", constructorElement);
                    }
                    if (!this.processedInPreviousRoundOrCompilationUnit(constructorElement)) {
                        InjectValidator.this.superficialValidation.validateAnnotationsOf(constructorElement);
                        for (Object qualifier : InjectValidator.this.injectionAnnotations.getQualifiers(constructorElement)) {
                            builder.addError(String.format("@Qualifier annotations are not allowed on @%s constructors", injectAnnotationName), constructorElement, (XAnnotation)qualifier);
                        }
                        String scopeErrorMsg = String.format("@Scope annotations are not allowed on @%s constructors", injectAnnotationName);
                        if (InjectionAnnotations.hasInjectAnnotation(constructorElement)) {
                            scopeErrorMsg = scopeErrorMsg + "; annotate the class instead";
                        }
                        for (Scope scope : InjectValidator.this.injectionAnnotations.getScopes(constructorElement)) {
                            builder.addError(scopeErrorMsg, constructorElement, scope.scopeAnnotation().xprocessing());
                        }
                    }
                    HashSet<AssistedInjectionAnnotations.AssistedParameter> uniqueAssistedParameters = new HashSet<AssistedInjectionAnnotations.AssistedParameter>();
                    for (XExecutableParameterElement parameter : constructorElement.getParameters()) {
                        InjectValidator.this.superficialValidation.validateTypeOf(parameter);
                        if (AssistedInjectionAnnotations.isAssistedParameter(parameter)) {
                            builder.addSubreport(InjectValidator.this.assistedValidator.validate(parameter));
                            AssistedInjectionAnnotations.AssistedParameter assistedParameter = AssistedInjectionAnnotations.AssistedParameter.create(parameter, parameter.getType());
                            if (uniqueAssistedParameters.add(assistedParameter)) continue;
                            builder.addError(String.format("@AssistedInject constructor has duplicate @Assisted type: %s. Consider setting an identifier on the parameter by using @Assisted(\"identifier\") in both the factory and @AssistedInject constructor", assistedParameter), assistedParameter.element());
                            continue;
                        }
                        this.validateDependencyRequest(builder, parameter);
                    }
                    if (this.throwsCheckedExceptions(constructorElement)) {
                        builder.addItem(String.format("Dagger does not support checked exceptions on @%s constructors", injectAnnotationName), this.privateMemberDiagnosticKind, constructorElement);
                    }
                    this.checkInjectIntoPrivateClass(constructorElement, builder);
                    enclosingElement = constructorElement.getEnclosingElement();
                    if (enclosingElement.isAbstract()) {
                        builder.addError(String.format("@%s is nonsense on the constructor of an abstract class", injectAnnotationName), constructorElement);
                    }
                    if (enclosingElement.isNested() && !enclosingElement.isStatic()) {
                        builder.addError(String.format("@%s constructors are invalid on inner classes. Did you mean to make the class static?", injectAnnotationName), constructorElement);
                    }
                    scopes = InjectValidator.this.injectionAnnotations.getScopes(constructorElement.getEnclosingElement());
                    if (!InjectionAnnotations.hasAssistedInjectAnnotation(constructorElement)) break block17;
                    for (Scope scope : scopes) {
                        builder.addError("A type with an @AssistedInject-annotated constructor cannot be scoped", enclosingElement, scope.scopeAnnotation().xprocessing());
                    }
                    break block18;
                }
                if (scopes.size() <= 1) break block18;
                for (Scope scope : scopes) {
                    builder.addError("A single binding may not declare more than one @Scope", enclosingElement, scope.scopeAnnotation().xprocessing());
                }
            }
            return builder.build();
        }

        private ValidationReport validateField(XFieldElement fieldElement) {
            InjectValidator.this.superficialValidation.validateTypeOf(fieldElement);
            ValidationReport.Builder builder = ValidationReport.about(fieldElement);
            if (fieldElement.isFinal()) {
                builder.addError("@Inject fields may not be final", fieldElement);
            }
            if (fieldElement.isPrivate()) {
                builder.addItem("Dagger does not support injection into private fields", this.privateMemberDiagnosticKind, fieldElement);
            }
            if (fieldElement.isStatic()) {
                builder.addItem("Dagger does not support injection into static fields", this.staticMemberDiagnosticKind, fieldElement);
            }
            if (fieldElement.isProtected() && fieldElement.getEnclosingElement().isFromKotlin()) {
                builder.addError("Dagger injector does not have access to kotlin protected fields", fieldElement);
            }
            this.validateDependencyRequest(builder, fieldElement);
            return builder.build();
        }

        private ValidationReport validateMethod(XMethodElement methodElement) {
            InjectValidator.this.superficialValidation.validateTypeOf(methodElement);
            ValidationReport.Builder builder = ValidationReport.about(methodElement);
            if (methodElement.isAbstract()) {
                builder.addError("Methods with @Inject may not be abstract", methodElement);
            }
            if (methodElement.isPrivate()) {
                builder.addItem("Dagger does not support injection into private methods", this.privateMemberDiagnosticKind, methodElement);
            }
            if (methodElement.isStatic()) {
                builder.addItem("Dagger does not support injection into static methods", this.staticMemberDiagnosticKind, methodElement);
            }
            if (XMethodElements.hasTypeParameters(methodElement)) {
                builder.addError("Methods with @Inject may not declare type parameters", methodElement);
            }
            if (!methodElement.getThrownTypes().isEmpty()) {
                builder.addError("Methods with @Inject may not throw checked exceptions. Please wrap your exceptions in a RuntimeException instead.", methodElement);
            }
            for (XExecutableParameterElement parameter : methodElement.getParameters()) {
                InjectValidator.this.superficialValidation.validateTypeOf(parameter);
                this.validateDependencyRequest(builder, parameter);
            }
            return builder.build();
        }

        private void validateDependencyRequest(ValidationReport.Builder builder, XVariableElement parameter) {
            InjectValidator.this.dependencyRequestValidator.validateDependencyRequest(builder, parameter, parameter.getType());
            InjectValidator.this.dependencyRequestValidator.checkNotProducer(builder, parameter);
        }

        public ValidationReport validateForMembersInjection(XTypeElement typeElement) {
            return !this.processedInPreviousRoundOrCompilationUnit(typeElement) ? this.validate(typeElement) : this.validateForMembersInjectionInternal(typeElement);
        }

        private ValidationReport validateForMembersInjectionInternal(XTypeElement typeElement) {
            return Util.reentrantComputeIfAbsent(this.membersInjectionReports, typeElement, this::validateForMembersInjectionInternalUncached);
        }

        private ValidationReport validateForMembersInjectionInternalUncached(XTypeElement typeElement) {
            ValidationReport report;
            InjectValidator.this.superficialValidation.validateTypeOf(typeElement);
            ValidationReport.Builder builder = ValidationReport.about(typeElement);
            boolean hasInjectedMembers = false;
            for (XFieldElement field : typeElement.getDeclaredFields()) {
                if (!InjectionAnnotations.hasInjectAnnotation(field)) continue;
                hasInjectedMembers = true;
                report = this.validateField(field);
                if (report.isClean()) continue;
                builder.addSubreport(report);
            }
            for (XMethodElement method : typeElement.getDeclaredMethods()) {
                if (!InjectionAnnotations.hasInjectAnnotation(method)) continue;
                hasInjectedMembers = true;
                report = this.validateMethod(method);
                if (report.isClean()) continue;
                builder.addSubreport(report);
            }
            if (hasInjectedMembers) {
                this.checkInjectIntoPrivateClass(typeElement, builder);
                this.checkInjectIntoKotlinObject(typeElement, builder);
            }
            Optional.ofNullable(typeElement.getSuperType()).filter(supertype -> !supertype.asTypeName().equals(XTypeName.ANY_OBJECT)).ifPresent(supertype -> {
                InjectValidator.this.superficialValidation.validateSuperTypeOf(typeElement);
                ValidationReport report = this.validateForMembersInjection(supertype.getTypeElement());
                if (!report.isClean()) {
                    builder.addSubreport(report);
                }
            });
            return builder.build();
        }

        private boolean throwsCheckedExceptions(XConstructorElement constructorElement) {
            XType runtimeException = InjectValidator.this.processingEnv.findType(XTypeNames.RUNTIME_EXCEPTION);
            XType error = InjectValidator.this.processingEnv.findType(XTypeNames.ERROR);
            InjectValidator.this.superficialValidation.validateThrownTypesOf(constructorElement);
            return !constructorElement.getThrownTypes().stream().allMatch(type -> XTypes.isSubtype(type, runtimeException) || XTypes.isSubtype(type, error));
        }

        private void checkInjectIntoPrivateClass(XElement element, ValidationReport.Builder builder) {
            if (XTypeElements.isEffectivelyPrivate(XElements.closestEnclosingTypeElement(element))) {
                builder.addItem("Dagger does not support injection into private classes", this.privateMemberDiagnosticKind, element);
            }
        }

        private void checkInjectIntoKotlinObject(XTypeElement element, ValidationReport.Builder builder) {
            if (element.isKotlinObject() || element.isCompanionObject()) {
                builder.addError("Dagger does not support injection into Kotlin objects", element);
            }
        }

        private boolean processedInPreviousRoundOrCompilationUnit(XConstructorElement injectConstructor) {
            return InjectValidator.this.processingEnv.findTypeElement(SourceFiles.factoryNameForElement(injectConstructor)) != null;
        }

        private boolean processedInPreviousRoundOrCompilationUnit(XTypeElement membersInjectedType) {
            return InjectValidator.this.processingEnv.findTypeElement(SourceFiles.membersInjectorNameForType(membersInjectedType)) != null;
        }
    }
}

