/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.FormatMethod;
import dagger.internal.codegen.base.ValidationReport;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.validation.BindingElementValidator;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XMethodElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotated;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XVariableElement;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;

abstract class BindingMethodValidator
extends BindingElementValidator<XMethodElement> {
    private final XClassName methodAnnotation;
    private final ImmutableSet<XClassName> enclosingElementAnnotations;
    private final Abstractness abstractness;
    private final ExceptionSuperclass exceptionSuperclass;
    private final XProcessingEnv processingEnv;
    private final DependencyRequestValidator dependencyRequestValidator;

    protected BindingMethodValidator(XClassName methodAnnotation, XClassName enclosingElementAnnotation, Abstractness abstractness, ExceptionSuperclass exceptionSuperclass, BindingElementValidator.AllowsMultibindings allowsMultibindings, BindingElementValidator.AllowsScoping allowsScoping, XProcessingEnv processingEnv, DependencyRequestValidator dependencyRequestValidator, InjectionAnnotations injectionAnnotations) {
        this(methodAnnotation, (Iterable<XClassName>)ImmutableSet.of((Object)enclosingElementAnnotation), abstractness, exceptionSuperclass, allowsMultibindings, allowsScoping, processingEnv, dependencyRequestValidator, injectionAnnotations);
    }

    protected BindingMethodValidator(XClassName methodAnnotation, Iterable<XClassName> enclosingElementAnnotations, Abstractness abstractness, ExceptionSuperclass exceptionSuperclass, BindingElementValidator.AllowsMultibindings allowsMultibindings, BindingElementValidator.AllowsScoping allowsScoping, XProcessingEnv processingEnv, DependencyRequestValidator dependencyRequestValidator, InjectionAnnotations injectionAnnotations) {
        super(allowsMultibindings, allowsScoping, injectionAnnotations);
        this.methodAnnotation = methodAnnotation;
        this.enclosingElementAnnotations = ImmutableSet.copyOf(enclosingElementAnnotations);
        this.abstractness = abstractness;
        this.exceptionSuperclass = exceptionSuperclass;
        this.processingEnv = processingEnv;
        this.dependencyRequestValidator = dependencyRequestValidator;
    }

    final XClassName methodAnnotation() {
        return this.methodAnnotation;
    }

    @FormatMethod
    protected final String bindingMethods(String ruleFormat, Object ... args) {
        return this.bindingElements(ruleFormat, args);
    }

    @Override
    protected final String bindingElements() {
        return String.format("@%s methods", this.methodAnnotation.getSimpleName());
    }

    @Override
    protected final String bindingElementTypeVerb() {
        return "return";
    }

    protected static enum ExceptionSuperclass {
        NO_EXCEPTIONS{

            @Override
            protected String errorMessage(BindingMethodValidator validator) {
                return validator.bindingMethods("may not throw", new Object[0]);
            }

            @Override
            protected void checkThrows(BindingMethodValidator validator, XExecutableElement element, ValidationReport.Builder report) {
                if (!element.getThrownTypes().isEmpty()) {
                    report.addError(validator.bindingMethods("may not throw", new Object[0]));
                    return;
                }
            }
        }
        ,
        EXCEPTION(XTypeNames.EXCEPTION){

            @Override
            protected String errorMessage(BindingMethodValidator validator) {
                return validator.bindingMethods("may only throw unchecked exceptions or exceptions subclassing Exception", new Object[0]);
            }
        }
        ,
        RUNTIME_EXCEPTION(XTypeNames.RUNTIME_EXCEPTION){

            @Override
            protected String errorMessage(BindingMethodValidator validator) {
                return validator.bindingMethods("may only throw unchecked exceptions", new Object[0]);
            }
        };

        private final XClassName superclass;

        private ExceptionSuperclass() {
            this((XClassName)null);
        }

        private ExceptionSuperclass(XClassName superclass) {
            this.superclass = superclass;
        }

        protected void checkThrows(BindingMethodValidator validator, XExecutableElement element, ValidationReport.Builder report) {
            XType exceptionSupertype = validator.processingEnv.findType(this.superclass);
            XType errorType = validator.processingEnv.findType(XTypeNames.ERROR);
            for (XType thrownType : element.getThrownTypes()) {
                if (XTypes.isSubtype(thrownType, exceptionSupertype) || XTypes.isSubtype(thrownType, errorType)) continue;
                report.addError(this.errorMessage(validator));
                break;
            }
        }

        protected abstract String errorMessage(BindingMethodValidator var1);
    }

    protected static enum Abstractness {
        MUST_BE_ABSTRACT,
        MUST_BE_CONCRETE;

    }

    protected abstract class MethodValidator
    extends BindingElementValidator.ElementValidator {
        private final XMethodElement method;

        protected MethodValidator(XMethodElement method) {
            super((BindingElementValidator)BindingMethodValidator.this, (XElement)method);
            this.method = method;
        }

        @Override
        protected final Optional<XType> bindingElementType() {
            return Optional.of(this.method.getReturnType());
        }

        @Override
        protected final void checkAdditionalProperties() {
            this.checkNotExtensionFunction();
            this.checkEnclosingElement();
            this.checkTypeParameters();
            this.checkNotPrivate();
            this.checkAbstractness();
            this.checkThrows();
            this.checkParameters();
            this.checkAdditionalMethodProperties();
        }

        protected void checkAdditionalMethodProperties() {
        }

        private void checkNotExtensionFunction() {
            if (this.method.isExtensionFunction()) {
                this.report.addError(BindingMethodValidator.this.bindingMethods("can not be an extension function", new Object[0]));
            }
        }

        private void checkEnclosingElement() {
            XTypeElement enclosingTypeElement = XMethodElements.getEnclosingTypeElement(this.method);
            if (enclosingTypeElement.isCompanionObject()) {
                enclosingTypeElement = enclosingTypeElement.getEnclosingTypeElement();
            }
            if (!XElements.hasAnyAnnotation((XAnnotated)enclosingTypeElement, (Collection<XClassName>)BindingMethodValidator.this.enclosingElementAnnotations)) {
                this.report.addError(BindingMethodValidator.this.bindingMethods("can only be present within a @%s", BindingMethodValidator.this.enclosingElementAnnotations.stream().map(XClassName::getSimpleName).collect(Collectors.joining(" or @"))));
            }
        }

        private void checkTypeParameters() {
            if (XMethodElements.hasTypeParameters(this.method)) {
                this.report.addError(BindingMethodValidator.this.bindingMethods("may not have type parameters", new Object[0]));
            }
        }

        private void checkNotPrivate() {
            if (this.method.isPrivate()) {
                this.report.addError(BindingMethodValidator.this.bindingMethods("cannot be private", new Object[0]));
            }
        }

        private void checkAbstractness() {
            boolean isAbstract = this.method.isAbstract();
            switch (BindingMethodValidator.this.abstractness.ordinal()) {
                case 0: {
                    if (isAbstract) break;
                    this.report.addError(BindingMethodValidator.this.bindingMethods("must be abstract", new Object[0]));
                    break;
                }
                case 1: {
                    if (!isAbstract) break;
                    this.report.addError(BindingMethodValidator.this.bindingMethods("cannot be abstract", new Object[0]));
                }
            }
        }

        private void checkThrows() {
            BindingMethodValidator.this.exceptionSuperclass.checkThrows(BindingMethodValidator.this, this.method, this.report);
        }

        protected void checkParameters() {
            for (XVariableElement xVariableElement : this.method.getParameters()) {
                this.checkParameter(xVariableElement);
            }
        }

        protected void checkParameter(XVariableElement parameter) {
            BindingMethodValidator.this.dependencyRequestValidator.validateDependencyRequest(this.report, parameter, parameter.getType());
        }
    }
}

