/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.processingstep;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.processingstep.TypeCheckingProcessingStep;
import dagger.internal.codegen.writing.LazyMapKeyProxyGenerator;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

final class LazyClassKeyProcessingStep
extends TypeCheckingProcessingStep<XElement> {
    private static final String PROGUARD_KEEP_RULE = "-keep,allowobfuscation,allowshrinking class ";
    private final SetMultimap<XClassName, XClassName> lazyMapKeysByModule = LinkedHashMultimap.create();
    private final LazyMapKeyProxyGenerator lazyMapKeyProxyGenerator;

    @Inject
    LazyClassKeyProcessingStep(LazyMapKeyProxyGenerator lazyMapKeyProxyGenerator) {
        this.lazyMapKeyProxyGenerator = lazyMapKeyProxyGenerator;
    }

    public ImmutableSet<XClassName> annotationClassNames() {
        return ImmutableSet.of((Object)XTypeNames.LAZY_CLASS_KEY);
    }

    @Override
    protected void process(XElement element, ImmutableSet<XClassName> annotations) {
        XClassName lazyClassKey = element.getAnnotation(XTypeNames.LAZY_CLASS_KEY).getAsType("value").getTypeElement().asClassName();
        if (!LazyClassKeyProcessingStep.isMapBinding(element) || !LazyClassKeyProcessingStep.isModuleOrProducerModule(element.getEnclosingElement())) {
            return;
        }
        XTypeElement moduleElement = XElements.asTypeElement(element.getEnclosingElement());
        this.lazyMapKeysByModule.put((Object)moduleElement.asClassName(), (Object)lazyClassKey);
        XMethodElement method = XElements.asMethod(element);
        this.lazyMapKeyProxyGenerator.generate(method);
    }

    private static boolean isMapBinding(XElement element) {
        return element.hasAnnotation(XTypeNames.INTO_MAP) && (element.hasAnnotation(XTypeNames.BINDS) || element.hasAnnotation(XTypeNames.PROVIDES) || element.hasAnnotation(XTypeNames.PRODUCES));
    }

    private static boolean isModuleOrProducerModule(XElement element) {
        return XElementKt.isTypeElement(element) && (element.hasAnnotation(XTypeNames.MODULE) || element.hasAnnotation(XTypeNames.PRODUCER_MODULE));
    }

    @Override
    public void processOver(XProcessingEnv env, Map<String, ? extends Set<? extends XElement>> elementsByAnnotation) {
        super.processOver(env, elementsByAnnotation);
        this.lazyMapKeysByModule.asMap().forEach((moduleClassName, lazyClassKeys) -> {
            XTypeElement originatingElement = env.requireTypeElement((XTypeName)moduleClassName);
            Path proguardFile = Path.of("META-INF/proguard", LazyClassKeyProcessingStep.getFullyQualifiedEnclosedClassName(moduleClassName) + "_LazyClassKeys.pro");
            String proguardFileContents = lazyClassKeys.stream().map(lazyClassKey -> PROGUARD_KEEP_RULE + lazyClassKey.getCanonicalName()).collect(Collectors.joining("\n"));
            this.writeResource(env.getFiler(), originatingElement, proguardFile, proguardFileContents);
        });
        this.lazyMapKeysByModule.clear();
    }

    private void writeResource(XFiler filer, XElement originatingElement, Path path, String contents) {
        try (OutputStream outputStream = filer.writeResource(path, (List<? extends XElement>)ImmutableList.of((Object)originatingElement), XFiler.Mode.Isolating);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
            writer.write(contents);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getFullyQualifiedEnclosedClassName(XClassName className) {
        return Joiner.on((char)'_').join((Iterable)ImmutableList.builder().add((Object)className.getPackageName().replace('.', '_')).addAll(className.getSimpleNames()).build());
    }
}

