/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.Binding;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.DiagnosticReporter;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugin;
import javax.inject.Inject;

final class NullableBindingValidator
extends ValidationBindingGraphPlugin {
    private final CompilerOptions compilerOptions;

    @Inject
    NullableBindingValidator(CompilerOptions compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    @Override
    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        for (Binding binding : this.nullableBindings(bindingGraph)) {
            for (BindingGraph.DependencyEdge dependencyEdge : this.nonNullableDependencies(bindingGraph, binding)) {
                diagnosticReporter.reportDependency(this.compilerOptions.nullableValidationKind(), dependencyEdge, NullableBindingValidator.nullableToNonNullable(binding.key().toString(), binding.toString()));
            }
        }
    }

    @Override
    public String pluginName() {
        return "Dagger/Nullable";
    }

    private ImmutableList<Binding> nullableBindings(BindingGraph bindingGraph) {
        return (ImmutableList)bindingGraph.bindings().stream().filter(binding -> binding.isNullable()).collect(DaggerStreams.toImmutableList());
    }

    private ImmutableSet<BindingGraph.DependencyEdge> nonNullableDependencies(BindingGraph bindingGraph, Binding binding) {
        return (ImmutableSet)bindingGraph.network().inEdges((Object)binding).stream().flatMap(DaggerStreams.instancesOf(BindingGraph.DependencyEdge.class)).filter(edge -> !edge.dependencyRequest().isNullable()).collect(DaggerStreams.toImmutableSet());
    }

    @VisibleForTesting
    static String nullableToNonNullable(String key, String binding) {
        return String.format("%s is not nullable, but is being provided by %s", key, binding);
    }
}

