/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.base.MapKeyAccessibility;
import dagger.internal.codegen.binding.AnnotationExpression;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotationValue;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeKt;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public final class MapKeys {
    public static final String LAZY_CLASS_KEY_NAME_FIELD = "lazyClassKeyName";
    public static final String KEEP_FIELD_TYPE_FIELD = "keepFieldType";

    static Optional<XAnnotation> getMapKey(XElement bindingElement) {
        return (Optional)MapKeys.getMapKeys(bindingElement).stream().collect(DaggerCollectors.toOptional());
    }

    public static ImmutableSet<XAnnotation> getMapKeys(XElement bindingElement) {
        return XElements.getAnnotatedAnnotations(bindingElement, XTypeNames.MAP_KEY);
    }

    private static Optional<XAnnotationValue> unwrapValue(XAnnotation mapKey) {
        XTypeElement mapKeyType = mapKey.getType().getTypeElement();
        XAnnotation mapKeyAnnotation = mapKeyType.getAnnotation(XTypeNames.MAP_KEY);
        Preconditions.checkArgument((mapKeyAnnotation != null ? 1 : 0) != 0, (String)"%s is not annotated with @MapKey", (Object)mapKeyType);
        return mapKeyAnnotation.getAsBoolean("unwrapValue") ? Optional.of((XAnnotationValue)Iterables.getOnlyElement(mapKey.getAnnotationValues())) : Optional.empty();
    }

    static XType mapKeyType(XAnnotation mapKey) {
        return MapKeys.unwrapValue(mapKey).isPresent() ? MapKeys.getUnwrappedMapKeyType(mapKey.getType()) : mapKey.getType();
    }

    public static XType getUnwrappedMapKeyType(XType mapKeyAnnotationType) {
        Preconditions.checkArgument((XTypes.isDeclared(mapKeyAnnotationType) && mapKeyAnnotationType.getTypeElement().isAnnotationClass() ? 1 : 0) != 0, (String)"%s is not an annotation type", (Object)mapKeyAnnotationType);
        XMethodElement annotationValueMethod = (XMethodElement)Iterables.getOnlyElement(mapKeyAnnotationType.getTypeElement().getDeclaredMethods());
        XType annotationValueType = annotationValueMethod.getReturnType();
        if (XTypeKt.isArray(annotationValueType)) {
            throw new IllegalArgumentException(mapKeyAnnotationType + "." + XElements.getSimpleName(annotationValueMethod) + " cannot be an array");
        }
        return XTypes.isTypeOf(annotationValueType, XTypeNames.KCLASS) ? XTypes.rewrapType(annotationValueType, XTypeNames.CLASS) : annotationValueType.boxed();
    }

    public static XCodeBlock getMapKeyExpression(ContributionBinding binding, XClassName requestingClass, XProcessingEnv processingEnv) {
        XAnnotation mapKeyAnnotation = binding.mapKey().get();
        return MapKeyAccessibility.isMapKeyAccessibleFrom(mapKeyAnnotation, requestingClass.getPackageName()) ? MapKeys.directMapKeyExpression(mapKeyAnnotation, processingEnv) : XCodeBlock.of("%T.create()", MapKeys.mapKeyProxyClassName(binding));
    }

    private static XCodeBlock directMapKeyExpression(XAnnotation mapKey, XProcessingEnv processingEnv) {
        Optional<XAnnotationValue> unwrappedValue = MapKeys.unwrapValue(mapKey);
        if (mapKey.getQualifiedName().contentEquals("dagger.android.AndroidInjectionKey")) {
            XTypeElement unwrappedType = DaggerSuperficialValidation.requireTypeElement(processingEnv, unwrappedValue.get().asString());
            return XCodeBlock.of("%T.of(%S)", XClassName.get("dagger.android.internal", "AndroidInjectionKeys"), unwrappedType.asClassName().getReflectionName());
        }
        AnnotationExpression annotationExpression = new AnnotationExpression(mapKey);
        return unwrappedValue.isPresent() ? annotationExpression.getValueExpression(unwrappedValue.get()) : annotationExpression.getAnnotationInstanceExpression();
    }

    public static XClassName mapKeyProxyClassName(ContributionBinding binding) {
        return SourceFiles.elementBasedClassName(XElements.asExecutable(binding.bindingElement().get()), "MapKey");
    }

    public static Optional<XFunSpec> mapKeyFactoryMethod(ContributionBinding binding, XProcessingEnv processingEnv) {
        return binding.mapKey().filter(mapKey -> !MapKeyAccessibility.isMapKeyPubliclyAccessible(mapKey)).map(mapKey -> XFunSpecs.methodBuilder("create").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(MapKeys.mapKeyType(mapKey).asTypeName()).addStatement("return %L", MapKeys.directMapKeyExpression(mapKey, processingEnv)).build());
    }

    public static boolean useLazyClassKey(Binding binding, BindingGraph graph) {
        if (!binding.dependencies().isEmpty()) {
            ContributionBinding contributionBinding = graph.contributionBinding(((DependencyRequest)binding.dependencies().iterator().next()).key());
            return contributionBinding.mapKey().isPresent() && contributionBinding.mapKey().get().getTypeElement().asClassName().equals(XTypeNames.LAZY_CLASS_KEY);
        }
        return false;
    }

    public static XCodeBlock getLazyClassMapKeyExpression(ContributionBinding contributionBinding) {
        return XCodeBlock.of("%T.%N", MapKeys.lazyClassKeyProxyClassName(XElements.asMethod(contributionBinding.bindingElement().get())), LAZY_CLASS_KEY_NAME_FIELD);
    }

    public static XClassName lazyClassKeyProxyClassName(XMethodElement methodElement) {
        return SourceFiles.elementBasedClassName(methodElement, "_LazyMapKey");
    }

    private MapKeys() {
    }
}

