/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.model.Binding;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import java.util.Optional;

public final class RequestKinds {
    private static final ImmutableMap<RequestKind, XClassName> FRAMEWORK_CLASSES = ImmutableMap.of((Object)((Object)RequestKind.PROVIDER), (Object)XTypeNames.JAVAX_PROVIDER, (Object)((Object)RequestKind.LAZY), (Object)XTypeNames.LAZY, (Object)((Object)RequestKind.PRODUCER), (Object)XTypeNames.PRODUCER, (Object)((Object)RequestKind.PRODUCED), (Object)XTypeNames.PRODUCED);

    public static XType requestType(RequestKind requestKind, XType type, XProcessingEnv processingEnv) {
        switch (requestKind) {
            case INSTANCE: {
                return type;
            }
            case PROVIDER_OF_LAZY: {
                return XProcessingEnvs.wrapType(XTypeNames.JAVAX_PROVIDER, RequestKinds.requestType(RequestKind.LAZY, type, processingEnv), processingEnv);
            }
            case FUTURE: {
                return XProcessingEnvs.wrapType(XTypeNames.LISTENABLE_FUTURE, type, processingEnv);
            }
        }
        return XProcessingEnvs.wrapType(RequestKinds.frameworkClassName(requestKind), type, processingEnv);
    }

    public static XTypeName requestTypeName(RequestKind requestKind, XTypeName keyType) {
        switch (requestKind) {
            case INSTANCE: {
                return keyType;
            }
            case PROVIDER: {
                return XTypeNames.javaxProviderOf(keyType);
            }
            case LAZY: {
                return XTypeNames.lazyOf(keyType);
            }
            case PROVIDER_OF_LAZY: {
                return XTypeNames.javaxProviderOf(XTypeNames.lazyOf(keyType));
            }
            case PRODUCER: {
                return XTypeNames.producerOf(keyType);
            }
            case PRODUCED: {
                return XTypeNames.producedOf(keyType);
            }
            case FUTURE: {
                return XTypeNames.listenableFutureOf(keyType);
            }
        }
        throw new AssertionError((Object)requestKind);
    }

    public static RequestKind getRequestKind(XType type) {
        XTypes.checkTypePresent(type);
        if (!XTypes.isDeclared(type) || type.getTypeArguments().isEmpty()) {
            return RequestKind.INSTANCE;
        }
        if (XTypes.isTypeOf(type, XTypeNames.providerTypeNames())) {
            return XTypes.isTypeOf(XTypes.unwrapType(type), XTypeNames.LAZY) ? RequestKind.PROVIDER_OF_LAZY : RequestKind.PROVIDER;
        }
        return ((Optional)FRAMEWORK_CLASSES.keySet().stream().filter(kind -> XTypes.isTypeOf(type, (XClassName)FRAMEWORK_CLASSES.get((Object)kind))).collect(DaggerCollectors.toOptional())).orElse(RequestKind.INSTANCE);
    }

    public static XType extractKeyType(XType type) {
        return RequestKinds.extractKeyType(RequestKinds.getRequestKind(type), type);
    }

    private static XType extractKeyType(RequestKind requestKind, XType type) {
        switch (requestKind) {
            case INSTANCE: {
                return type;
            }
            case PROVIDER_OF_LAZY: {
                return RequestKinds.extractKeyType(RequestKind.LAZY, RequestKinds.extractKeyType(RequestKind.PROVIDER, type));
            }
        }
        return XTypes.unwrapType(type);
    }

    public static XClassName frameworkClassName(RequestKind requestKind) {
        Preconditions.checkArgument((boolean)FRAMEWORK_CLASSES.containsKey((Object)requestKind), (String)"no framework class for %s", (Object)((Object)requestKind));
        return (XClassName)FRAMEWORK_CLASSES.get((Object)requestKind);
    }

    public static boolean canBeSatisfiedByProductionBinding(RequestKind requestKind, boolean isEntryPoint) {
        switch (requestKind) {
            case PROVIDER_OF_LAZY: 
            case PROVIDER: 
            case LAZY: 
            case MEMBERS_INJECTION: {
                return false;
            }
            case INSTANCE: 
            case PRODUCED: {
                return !isEntryPoint;
            }
            case FUTURE: 
            case PRODUCER: {
                return true;
            }
        }
        throw new AssertionError();
    }

    public static boolean dependencyCanBeProduction(BindingGraph.DependencyEdge edge, BindingGraph graph) {
        BindingGraph.Node source = (BindingGraph.Node)graph.network().incidentNodes((Object)edge).source();
        boolean isEntryPoint = source instanceof BindingGraph.ComponentNode;
        boolean isValidRequest = RequestKinds.canBeSatisfiedByProductionBinding(edge.dependencyRequest().kind(), isEntryPoint);
        if (isEntryPoint) {
            return isValidRequest;
        }
        if (source instanceof Binding) {
            return isValidRequest && ((Binding)source).isProduction();
        }
        throw new IllegalArgumentException("expected a dagger.internal.codegen.model.Binding or ComponentNode: " + source);
    }

    private RequestKinds() {
    }
}

