/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.base.AutoValue_ModuleAnnotation;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotated;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import java.util.Optional;

@AutoValue
public abstract class ModuleAnnotation {
    private static final ImmutableSet<XClassName> MODULE_ANNOTATIONS = ImmutableSet.of((Object)XTypeNames.MODULE, (Object)XTypeNames.PRODUCER_MODULE);
    private XAnnotation annotation;

    public final XAnnotation annotation() {
        return this.annotation;
    }

    public abstract XClassName className();

    public String simpleName() {
        return this.className().getSimpleName();
    }

    @Memoized
    public ImmutableList<XTypeElement> includes() {
        return (ImmutableList)this.annotation.getAsTypeList("includes").stream().map(XType::getTypeElement).collect(DaggerStreams.toImmutableList());
    }

    @Memoized
    public ImmutableList<XTypeElement> subcomponents() {
        return (ImmutableList)this.annotation.getAsTypeList("subcomponents").stream().map(XType::getTypeElement).collect(DaggerStreams.toImmutableList());
    }

    public static boolean isModuleAnnotation(XAnnotation annotation) {
        return MODULE_ANNOTATIONS.contains((Object)XAnnotations.asClassName(annotation));
    }

    public static ImmutableSet<XClassName> moduleAnnotations() {
        return MODULE_ANNOTATIONS;
    }

    private static ModuleAnnotation create(XAnnotation annotation) {
        Preconditions.checkArgument((boolean)ModuleAnnotation.isModuleAnnotation(annotation), (String)"%s is not a Module or ProducerModule annotation", (Object)annotation);
        AutoValue_ModuleAnnotation moduleAnnotation = new AutoValue_ModuleAnnotation(XAnnotations.asClassName(annotation));
        moduleAnnotation.annotation = annotation;
        return moduleAnnotation;
    }

    public static Optional<ModuleAnnotation> moduleAnnotation(XElement element, DaggerSuperficialValidation superficialValidation) {
        return XElements.getAnyAnnotation((XAnnotated)element, XTypeNames.MODULE, XTypeNames.PRODUCER_MODULE).map(annotation -> {
            superficialValidation.validateAnnotationOf(element, (XAnnotation)annotation);
            return ModuleAnnotation.create(annotation);
        });
    }
}

