/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.DelegateComponentProcessor;
import dagger.internal.codegen.compileroption.ProcessingEnvironmentCompilerOptions;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnvConfig;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingStep;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XRoundEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.javac.JavacBasicAnnotationProcessor;
import dagger.spi.model.BindingGraphPlugin;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;
import kotlin.jvm.functions.Function1;

@AutoService(value={Processor.class})
public final class ComponentProcessor
extends JavacBasicAnnotationProcessor {
    private final DelegateComponentProcessor delegate = new DelegateComponentProcessor();
    private final Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins;
    private final Optional<ImmutableSet<dagger.spi.BindingGraphPlugin>> legacyTestingPlugins;

    @VisibleForTesting
    public static ComponentProcessor withTestPlugins(BindingGraphPlugin ... testingPlugins) {
        return ComponentProcessor.withTestPlugins(Arrays.asList(testingPlugins));
    }

    @VisibleForTesting
    public static ComponentProcessor withTestPlugins(Iterable<BindingGraphPlugin> testingPlugins) {
        return new ComponentProcessor(Optional.of(ImmutableSet.copyOf(testingPlugins)), Optional.empty());
    }

    @VisibleForTesting
    public static ComponentProcessor forTesting(dagger.spi.BindingGraphPlugin ... testingPlugins) {
        return ComponentProcessor.forTesting(Arrays.asList(testingPlugins));
    }

    @VisibleForTesting
    public static ComponentProcessor forTesting(Iterable<dagger.spi.BindingGraphPlugin> testingPlugins) {
        return new ComponentProcessor(Optional.empty(), Optional.of(ImmutableSet.copyOf(testingPlugins)));
    }

    public ComponentProcessor() {
        this(Optional.empty(), Optional.empty());
    }

    private ComponentProcessor(Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins, Optional<ImmutableSet<dagger.spi.BindingGraphPlugin>> legacyTestingPlugins) {
        super((Function1<? super Map<String, String>, XProcessingEnvConfig>)((Function1)options -> DelegateComponentProcessor.PROCESSING_ENV_CONFIG));
        this.testingPlugins = testingPlugins;
        this.legacyTestingPlugins = legacyTestingPlugins;
    }

    @Override
    public void initialize(XProcessingEnv env) {
        this.delegate.initialize(env, this.testingPlugins, this.legacyTestingPlugins);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public ImmutableSet<String> getSupportedOptions() {
        return ImmutableSet.builder().addAll(ProcessingEnvironmentCompilerOptions.supportedOptions()).addAll(this.delegate.validationBindingGraphPlugins.allSupportedOptions()).addAll(this.delegate.externalBindingGraphPlugins.allSupportedOptions()).build();
    }

    @Override
    public Iterable<XProcessingStep> processingSteps() {
        return this.delegate.processingSteps();
    }

    @Override
    public void preRound(XProcessingEnv env, XRoundEnv roundEnv) {
        this.delegate.onProcessingRoundBegin();
    }

    @Override
    public void postRound(XProcessingEnv env, XRoundEnv roundEnv) {
        this.delegate.postRound(env, roundEnv);
    }
}

