/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.TypeSpec;
import com.squareup.kotlinpoet.KModifier;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.VisibilityModifier;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XAnnotationSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

public final class XTypeSpecs {
    public static Builder classBuilder(String name) {
        return new Builder(Builder.Kind.CLASS).name(name);
    }

    public static Builder classBuilder(XClassName className) {
        return new Builder(Builder.Kind.CLASS).name(className.getSimpleName());
    }

    public static Builder interfaceBuilder(String name) {
        return new Builder(Builder.Kind.INTERFACE).name(name);
    }

    public static Builder interfaceBuilder(XClassName className) {
        return new Builder(Builder.Kind.INTERFACE).name(className.getSimpleName());
    }

    public static Builder objectBuilder(String name) {
        return new Builder(Builder.Kind.OBJECT).name(name);
    }

    public static Builder anonymousClassBuilder() {
        return new Builder(Builder.Kind.ANONYMOUS_CLASS);
    }

    public static Builder annotationBuilder(String name) {
        return new Builder(Builder.Kind.ANNOTATION).name(name);
    }

    public static XTypeSpec.Builder toBuilder(XTypeSpec typeSpec) {
        return XConverters.toXPoet(XConverters.toJavaPoet(typeSpec).toBuilder(), XConverters.toKotlinPoet(typeSpec).toBuilder());
    }

    private XTypeSpecs() {
    }

    public static class Builder {
        private final Kind kind;
        private String name;
        private boolean isOpen;
        private boolean isStatic;
        private boolean isAbstract;
        private VisibilityModifier visibility = null;
        private XElement originatingElement;
        private final Set<String> alwaysQualifyNames = new LinkedHashSet<String>();
        private final List<XCodeBlock> javadocs = new ArrayList<XCodeBlock>();
        private XTypeName superclass;
        private final List<XTypeName> superinterfaces = new ArrayList<XTypeName>();
        private final List<XTypeName> typeVariableNames = new ArrayList<XTypeName>();
        private final List<XAnnotationSpec> annotations = new ArrayList<XAnnotationSpec>();
        private final List<XTypeSpec> types = new ArrayList<XTypeSpec>();
        private final List<XPropertySpec> properties = new ArrayList<XPropertySpec>();
        private final List<XFunSpec> functions = new ArrayList<XFunSpec>();

        private Builder(Kind kind) {
            this.kind = kind;
        }

        @CanIgnoreReturnValue
        private Builder name(String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder isStatic(boolean isStatic) {
            this.isStatic = isStatic;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder isOpen(boolean isOpen) {
            this.isOpen = isOpen;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder isAbstract(boolean isAbstract) {
            this.isAbstract = isAbstract;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder visibility(VisibilityModifier visibility) {
            this.visibility = visibility;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addJavadoc(String format, Object ... args) {
            this.javadocs.add(XCodeBlock.of(format, args));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addOriginatingElement(XElement originatingElement) {
            this.originatingElement = originatingElement;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder superType(XTypeElement superType) {
            if (superType.isClass()) {
                return this.avoidClashesWithNestedClasses(superType).superclass(superType.asClassName());
            }
            if (superType.isInterface()) {
                return this.avoidClashesWithNestedClasses(superType).addSuperinterface(superType.asClassName());
            }
            throw new AssertionError((Object)(superType + " is neither a class nor an interface."));
        }

        @CanIgnoreReturnValue
        public Builder avoidClashesWithNestedClasses(XTypeElement typeElement) {
            typeElement.getEnclosedTypeElements().stream().map(XElements::getSimpleName).forEach(this.alwaysQualifyNames::add);
            typeElement.getType().getSuperTypes().stream().filter(XTypes::isDeclared).map(XType::getTypeElement).forEach(this::avoidClashesWithNestedClasses);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder alwaysQualify(String name) {
            this.alwaysQualifyNames.add(name);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder superclass(XTypeName superclass) {
            this.superclass = superclass;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addSuperinterfaces(Collection<XTypeName> superinterfaces) {
            superinterfaces.forEach(this::addSuperinterface);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addSuperinterface(XTypeName superInterface) {
            this.superinterfaces.add(superInterface);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addModifiers(Modifier ... modifiers) {
            block8: for (Modifier modifier : modifiers) {
                switch (modifier) {
                    case PUBLIC: {
                        this.visibility(VisibilityModifier.PUBLIC);
                        continue block8;
                    }
                    case PRIVATE: {
                        this.visibility(VisibilityModifier.PRIVATE);
                        continue block8;
                    }
                    case PROTECTED: {
                        this.visibility(VisibilityModifier.PROTECTED);
                        continue block8;
                    }
                    case ABSTRACT: {
                        this.isOpen(true);
                        this.isAbstract(true);
                        continue block8;
                    }
                    case STATIC: {
                        this.isStatic(true);
                        continue block8;
                    }
                    case FINAL: {
                        this.isOpen(false);
                        continue block8;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected modifier: " + (Object)((Object)modifier)));
                    }
                }
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTypeVariables(Collection<? extends XType> typeVariables) {
            typeVariables.forEach(this::addTypeVariable);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTypeVariableNames(Collection<XTypeName> typeVariableNames) {
            typeVariableNames.forEach(this::addTypeVariable);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTypeVariable(XType type) {
            return this.addTypeVariable(type.asTypeName());
        }

        @CanIgnoreReturnValue
        public Builder addTypeVariable(XTypeName typeName) {
            this.typeVariableNames.add(typeName);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotations(Collection<XAnnotationSpec> annotations) {
            annotations.forEach(this::addAnnotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotationNames(Collection<XClassName> annotationNames) {
            annotationNames.forEach(this::addAnnotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotation(XAnnotationSpec annotation) {
            this.annotations.add(annotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotation(XClassName annotationName) {
            return this.addAnnotation(XAnnotationSpec.of(annotationName));
        }

        @CanIgnoreReturnValue
        public Builder addTypes(Collection<XTypeSpec> types) {
            types.forEach(this::addType);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addType(XTypeSpec type) {
            this.types.add(type);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addProperties(Collection<XPropertySpec> properties) {
            properties.forEach(this::addProperty);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addProperty(XPropertySpec property) {
            this.properties.add(property);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addFunctions(Collection<XFunSpec> functions) {
            functions.forEach(this::addFunction);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addFunction(XFunSpec function) {
            this.functions.add(function);
            return this;
        }

        public XTypeSpec build() {
            XTypeSpec.Builder builder;
            switch (this.kind.ordinal()) {
                case 0: {
                    builder = XTypeSpec.classBuilder(this.name, this.isOpen);
                    break;
                }
                case 1: {
                    builder = XConverters.toXPoet(TypeSpec.interfaceBuilder((String)this.name), com.squareup.kotlinpoet.TypeSpec.interfaceBuilder((String)this.name));
                    if (this.isOpen) {
                        XConverters.toKotlinPoet(builder).addModifiers(new KModifier[]{KModifier.OPEN});
                        break;
                    }
                    XConverters.toJavaPoet(builder).addModifiers(new Modifier[]{Modifier.FINAL});
                    break;
                }
                case 2: {
                    builder = XConverters.toXPoet(TypeSpec.annotationBuilder((String)this.name), com.squareup.kotlinpoet.TypeSpec.annotationBuilder((String)this.name));
                    break;
                }
                case 3: {
                    builder = XTypeSpec.objectBuilder(this.name);
                    break;
                }
                case 4: {
                    Preconditions.checkState((this.name == null ? 1 : 0) != 0);
                    builder = XTypeSpec.anonymousClassBuilder("", new Object[0]);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (this.originatingElement != null) {
                builder.addOriginatingElement(this.originatingElement);
            }
            if (this.isStatic) {
                XConverters.toJavaPoet(builder).addModifiers(new Modifier[]{Modifier.STATIC});
            }
            if (this.isAbstract) {
                builder.addAbstractModifier();
            }
            if (this.visibility != null) {
                builder.setVisibility(this.visibility);
            }
            for (String name : this.alwaysQualifyNames) {
                XConverters.toJavaPoet(builder).alwaysQualify(new String[]{name});
            }
            for (XCodeBlock javadoc : this.javadocs) {
                XConverters.toJavaPoet(builder).addJavadoc(XConverters.toJavaPoet(javadoc));
            }
            if (this.superclass != null) {
                builder.superclass(this.superclass);
            }
            this.superinterfaces.forEach(builder::addSuperinterface);
            builder.addTypeVariables(this.typeVariableNames);
            this.annotations.forEach(builder::addAnnotation);
            this.types.forEach(builder::addType);
            this.properties.forEach(builder::addProperty);
            this.functions.forEach(builder::addFunction);
            return builder.build();
        }

        private static enum Kind {
            CLASS,
            INTERFACE,
            ANNOTATION,
            OBJECT,
            ANONYMOUS_CLASS;

        }
    }
}

