/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.kotlinpoet.KModifier;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.VisibilityModifier;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XAnnotationSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Modifier;

public final class XPropertySpecs {
    public static XPropertySpec of(String name, XTypeName typeName, Modifier ... modifiers) {
        return XPropertySpecs.builder(name, typeName, modifiers).build();
    }

    public static Builder builder(String name, XTypeName typeName, Modifier ... modifiers) {
        return Builder.create(name, typeName, modifiers);
    }

    private XPropertySpecs() {
    }

    public static class Builder {
        private final String name;
        private final XTypeName typeName;
        private boolean isStatic = false;
        private boolean isMutable = true;
        private VisibilityModifier visibility = null;
        private XCodeBlock initializer = null;
        private final List<XCodeBlock> javadocs = new ArrayList<XCodeBlock>();
        private final List<XAnnotationSpec> annotations = new ArrayList<XAnnotationSpec>();

        private static Builder create(String name, XTypeName typeName, Modifier ... modifiers) {
            Builder builder = new Builder(name, typeName);
            builder.addModifiers(modifiers);
            return builder;
        }

        private Builder(String name, XTypeName typeName) {
            this.name = name;
            this.typeName = typeName;
        }

        public String getName() {
            return this.name;
        }

        public XTypeName getType() {
            return this.typeName;
        }

        @CanIgnoreReturnValue
        public Builder visibility(VisibilityModifier visibility) {
            this.visibility = visibility;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder isStatic(boolean isStatic) {
            this.isStatic = isStatic;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder isMutable(boolean isMutable) {
            this.isMutable = isMutable;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addJavadoc(String format, Object ... args) {
            this.javadocs.add(XCodeBlock.of(format, args));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addModifiers(Collection<Modifier> modifiers) {
            return this.addModifiers(modifiers.toArray(new Modifier[0]));
        }

        @CanIgnoreReturnValue
        public Builder addModifiers(Modifier ... modifiers) {
            block7: for (Modifier modifier : modifiers) {
                switch (modifier) {
                    case PUBLIC: {
                        this.visibility(VisibilityModifier.PUBLIC);
                        continue block7;
                    }
                    case PRIVATE: {
                        this.visibility(VisibilityModifier.PRIVATE);
                        continue block7;
                    }
                    case PROTECTED: {
                        this.visibility(VisibilityModifier.PROTECTED);
                        continue block7;
                    }
                    case STATIC: {
                        this.isStatic(true);
                        continue block7;
                    }
                    case FINAL: {
                        this.isMutable(false);
                        continue block7;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected modifier: " + (Object)((Object)modifier)));
                    }
                }
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotations(Collection<XAnnotationSpec> annotations) {
            annotations.forEach(this::addAnnotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotationNames(Collection<XClassName> annotationNames) {
            annotationNames.forEach(this::addAnnotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotation(XAnnotationSpec annotation) {
            this.annotations.add(annotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotation(XClassName annotationName) {
            return this.addAnnotation(XAnnotationSpec.of(annotationName));
        }

        @CanIgnoreReturnValue
        public Builder initializer(String format, Object ... args) {
            return this.initializer(XCodeBlock.of(format, args));
        }

        @CanIgnoreReturnValue
        public Builder initializer(XCodeBlock initializer) {
            Preconditions.checkState((this.initializer == null ? 1 : 0) != 0);
            this.initializer = initializer;
            return this;
        }

        public XPropertySpec build() {
            VisibilityModifier initialVisibility = this.visibility == null ? VisibilityModifier.PRIVATE : this.visibility;
            XPropertySpec.Builder builder = XPropertySpec.builder(this.name, this.typeName, initialVisibility, this.isMutable, false);
            if (this.visibility == null) {
                XConverters.toJavaPoet((XPropertySpec.Builder)builder).modifiers.remove((Object)Modifier.PRIVATE);
                XConverters.toKotlinPoet(builder).getModifiers().remove(KModifier.PRIVATE);
            }
            for (XCodeBlock javadoc : this.javadocs) {
                XConverters.toJavaPoet(builder).addJavadoc(XConverters.toJavaPoet(javadoc));
            }
            if (this.initializer != null) {
                builder.initializer(this.initializer);
            }
            if (this.isStatic) {
                XConverters.toJavaPoet(builder).addModifiers(new Modifier[]{Modifier.STATIC});
            }
            this.annotations.forEach(builder::addAnnotation);
            return builder.build();
        }
    }
}

