/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.Binding;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.DiagnosticReporter;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugin;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import javax.inject.Inject;
import javax.tools.Diagnostic;

final class DependsOnProductionExecutorValidator
extends ValidationBindingGraphPlugin {
    private final XProcessingEnv processingEnv;
    private final KeyFactory keyFactory;

    @Inject
    DependsOnProductionExecutorValidator(XProcessingEnv processingEnv, KeyFactory keyFactory) {
        this.processingEnv = processingEnv;
        this.keyFactory = keyFactory;
    }

    @Override
    public String pluginName() {
        return "Dagger/DependsOnProductionExecutor";
    }

    @Override
    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        if (!this.usesProducers()) {
            return;
        }
        Key productionImplementationExecutorKey = this.keyFactory.forProductionImplementationExecutor();
        Key productionExecutorKey = this.keyFactory.forProductionExecutor();
        bindingGraph.network().nodes().stream().flatMap(DaggerStreams.instancesOf(BindingGraph.MaybeBinding.class)).filter(node -> node.key().equals(productionExecutorKey)).flatMap(productionExecutor -> bindingGraph.requestingBindings((BindingGraph.MaybeBinding)productionExecutor).stream()).filter(binding -> !binding.key().equals(productionImplementationExecutorKey)).forEach(binding -> this.reportError(diagnosticReporter, (Binding)binding));
    }

    private void reportError(DiagnosticReporter diagnosticReporter, Binding binding) {
        diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, binding, "%s may not depend on the production executor", binding.key(), new Object[0]);
    }

    private boolean usesProducers() {
        return this.processingEnv.findTypeElement(XTypeNames.PRODUCES) != null;
    }
}

