/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.TypeSpec;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.VisibilityModifier;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XAnnotationSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

public final class XTypeSpecs {
    public static Builder classBuilder(String name) {
        return new Builder(Builder.Kind.CLASS).name(name);
    }

    public static Builder classBuilder(XClassName className) {
        return new Builder(Builder.Kind.CLASS).name(className.getSimpleName());
    }

    public static Builder interfaceBuilder(String name) {
        return new Builder(Builder.Kind.INTERFACE).name(name);
    }

    public static Builder interfaceBuilder(XClassName className) {
        return new Builder(Builder.Kind.INTERFACE).name(className.getSimpleName());
    }

    public static Builder objectBuilder(String name) {
        return new Builder(Builder.Kind.OBJECT).name(name);
    }

    public static Builder anonymousClassBuilder() {
        return new Builder(Builder.Kind.ANONYMOUS_CLASS);
    }

    public static Builder annotationBuilder(String name) {
        return new Builder(Builder.Kind.ANNOTATION).name(name);
    }

    public static XTypeSpec.Builder toBuilder(XTypeSpec typeSpec) {
        return XConverters.toXPoet((TypeSpec.Builder)XConverters.toJavaPoet((XTypeSpec)typeSpec).toBuilder(), (TypeSpec.Builder)XConverters.toKotlinPoet((XTypeSpec)typeSpec).toBuilder());
    }

    private XTypeSpecs() {
    }

    public static class Builder {
        private final Kind kind;
        private String name;
        private boolean isOpen;
        private boolean isStatic;
        private boolean isAbstract;
        private VisibilityModifier visibility = null;
        private XElement originatingElement;
        private final Set<String> alwaysQualifyNames = new LinkedHashSet<String>();
        private final List<XCodeBlock> javadocs = new ArrayList<XCodeBlock>();
        private Object superclass;
        private final List<Object> superinterfaces = new ArrayList<Object>();
        private final List<Object> typeVariableNames = new ArrayList<Object>();
        private final List<Object> annotations = new ArrayList<Object>();
        private final List<Object> types = new ArrayList<Object>();
        private final List<Object> properties = new ArrayList<Object>();
        private final List<Object> functions = new ArrayList<Object>();

        private Builder(Kind kind) {
            this.kind = kind;
        }

        @CanIgnoreReturnValue
        private Builder name(String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder isStatic(boolean isStatic) {
            this.isStatic = isStatic;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder isOpen(boolean isOpen) {
            this.isOpen = isOpen;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder isAbstract(boolean isAbstract) {
            this.isAbstract = isAbstract;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder visibility(VisibilityModifier visibility) {
            this.visibility = visibility;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addJavadoc(String format, Object ... args) {
            this.javadocs.add(XCodeBlock.of((String)format, (Object[])args));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addOriginatingElement(XElement originatingElement) {
            this.originatingElement = originatingElement;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder superType(XTypeElement superType) {
            if (superType.isClass()) {
                return this.avoidClashesWithNestedClasses(superType).superclass((XTypeName)superType.asClassName());
            }
            if (superType.isInterface()) {
                return this.avoidClashesWithNestedClasses(superType).addSuperinterface((XTypeName)superType.asClassName());
            }
            throw new AssertionError((Object)(superType + " is neither a class nor an interface."));
        }

        @CanIgnoreReturnValue
        public Builder avoidClashesWithNestedClasses(XTypeElement typeElement) {
            typeElement.getEnclosedTypeElements().stream().map(XElements::getSimpleName).forEach(this.alwaysQualifyNames::add);
            typeElement.getType().getSuperTypes().stream().filter(XTypes::isDeclared).map(XType::getTypeElement).forEach(this::avoidClashesWithNestedClasses);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder alwaysQualify(String name) {
            this.alwaysQualifyNames.add(name);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder superclass(XTypeName superclass) {
            this.superclass = superclass;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder superclass(TypeName superclass) {
            this.superclass = superclass;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addSuperinterfaces(Collection<XTypeName> superinterfaces) {
            superinterfaces.forEach(this::addSuperinterface);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addJavaSuperinterfaces(Collection<TypeName> superinterfaces) {
            superinterfaces.forEach(this::addSuperinterface);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addSuperinterface(XTypeName superInterface) {
            this.superinterfaces.add(superInterface);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addSuperinterface(TypeName superInterface) {
            this.superinterfaces.add(superInterface);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addModifiers(Modifier ... modifiers) {
            block8: for (Modifier modifier : modifiers) {
                switch (modifier) {
                    case PUBLIC: {
                        this.visibility(VisibilityModifier.PUBLIC);
                        continue block8;
                    }
                    case PRIVATE: {
                        this.visibility(VisibilityModifier.PRIVATE);
                        continue block8;
                    }
                    case PROTECTED: {
                        this.visibility(VisibilityModifier.PROTECTED);
                        continue block8;
                    }
                    case ABSTRACT: {
                        this.isOpen(true);
                        this.isAbstract(true);
                        continue block8;
                    }
                    case STATIC: {
                        this.isStatic(true);
                        continue block8;
                    }
                    case FINAL: {
                        this.isOpen(false);
                        continue block8;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected modifier: " + (Object)((Object)modifier)));
                    }
                }
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTypeVariables(Collection<? extends XType> typeVariables) {
            typeVariables.forEach(this::addTypeVariable);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTypeVariableNames(Collection<XTypeName> typeVariableNames) {
            typeVariableNames.forEach(this::addTypeVariable);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addJavaTypeVariableNames(Collection<TypeVariableName> typeVariableNames) {
            typeVariableNames.forEach(this::addTypeVariable);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTypeVariable(XType type) {
            return this.addTypeVariable(type.asTypeName());
        }

        @CanIgnoreReturnValue
        public Builder addTypeVariable(XTypeName typeName) {
            this.typeVariableNames.add(typeName);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addTypeVariable(TypeVariableName typeVariableName) {
            this.typeVariableNames.add(typeVariableName);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotations(Collection<XAnnotationSpec> annotations) {
            annotations.forEach(this::addAnnotation);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addJavaAnnotations(Collection<AnnotationSpec> annotations) {
            annotations.forEach(this::addAnnotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotationNames(Collection<XClassName> annotationNames) {
            annotationNames.forEach(this::addAnnotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotation(XAnnotationSpec annotation) {
            this.annotations.add(annotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotation(XClassName annotationName) {
            return this.addAnnotation(XAnnotationSpec.of((XClassName)annotationName));
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addAnnotation(Class<?> clazz) {
            this.addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get(clazz)).build());
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addAnnotation(AnnotationSpec annotation) {
            this.annotations.add(annotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTypes(Collection<XTypeSpec> types) {
            types.forEach(this::addType);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addJavaTypes(Collection<TypeSpec> javaTypes) {
            javaTypes.forEach(this::addType);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addType(XTypeSpec type) {
            this.types.add(type);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addType(TypeSpec type) {
            this.types.add(type);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addProperties(Collection<XPropertySpec> properties) {
            properties.forEach(this::addProperty);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addFields(Collection<FieldSpec> fields) {
            fields.forEach(this::addField);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addProperty(XPropertySpec property) {
            this.properties.add(property);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addField(FieldSpec field) {
            this.properties.add(field);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addField(TypeName type, String name, Modifier ... modifiers) {
            this.properties.add(FieldSpec.builder((TypeName)type, (String)name, (Modifier[])modifiers).build());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addFunctions(Collection<XFunSpec> functions) {
            functions.forEach(this::addFunction);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addFunction(XFunSpec function) {
            this.functions.add(function);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addMethods(Collection<MethodSpec> methods) {
            methods.forEach(this::addMethod);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addMethod(MethodSpec method) {
            this.functions.add(method);
            return this;
        }

        public XTypeSpec build() {
            XTypeSpec.Builder builder;
            switch (this.kind.ordinal()) {
                case 0: {
                    builder = XTypeSpec.classBuilder((String)this.name, (boolean)this.isOpen);
                    break;
                }
                case 1: {
                    builder = XConverters.toXPoet((TypeSpec.Builder)TypeSpec.interfaceBuilder((String)this.name), (TypeSpec.Builder)com.squareup.kotlinpoet.TypeSpec.interfaceBuilder((String)this.name));
                    if (this.isOpen) {
                        XConverters.toKotlinPoet((XTypeSpec.Builder)builder).addModifiers(new KModifier[]{KModifier.OPEN});
                        break;
                    }
                    XConverters.toJavaPoet((XTypeSpec.Builder)builder).addModifiers(new Modifier[]{Modifier.FINAL});
                    break;
                }
                case 2: {
                    builder = XConverters.toXPoet((TypeSpec.Builder)TypeSpec.annotationBuilder((String)this.name), (TypeSpec.Builder)com.squareup.kotlinpoet.TypeSpec.annotationBuilder((String)this.name));
                    break;
                }
                case 3: {
                    builder = XTypeSpec.objectBuilder((String)this.name);
                    break;
                }
                case 4: {
                    Preconditions.checkState((this.name == null ? 1 : 0) != 0);
                    builder = XTypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (this.originatingElement != null) {
                builder.addOriginatingElement(this.originatingElement);
            }
            if (this.isStatic) {
                XConverters.toJavaPoet((XTypeSpec.Builder)builder).addModifiers(new Modifier[]{Modifier.STATIC});
            }
            if (this.isAbstract) {
                builder.addAbstractModifier();
            }
            if (this.visibility != null) {
                builder.setVisibility(this.visibility);
            }
            for (String name : this.alwaysQualifyNames) {
                XConverters.toJavaPoet((XTypeSpec.Builder)builder).alwaysQualify(new String[]{name});
            }
            for (XCodeBlock javadoc : this.javadocs) {
                XConverters.toJavaPoet((XTypeSpec.Builder)builder).addJavadoc(XConverters.toJavaPoet((XCodeBlock)javadoc));
            }
            if (this.superclass != null) {
                if (this.superclass instanceof XTypeName) {
                    builder.superclass((XTypeName)this.superclass);
                } else if (this.superclass instanceof TypeName) {
                    XConverters.toJavaPoet((XTypeSpec.Builder)builder).superclass((TypeName)this.superclass);
                } else {
                    throw new AssertionError((Object)("Unexpected superclass class: " + this.superclass.getClass()));
                }
            }
            for (Object superinterface : this.superinterfaces) {
                if (superinterface instanceof XTypeName) {
                    builder.addSuperinterface((XTypeName)superinterface);
                    continue;
                }
                if (superinterface instanceof TypeName) {
                    XConverters.toJavaPoet((XTypeSpec.Builder)builder).addSuperinterface((TypeName)superinterface);
                    continue;
                }
                throw new AssertionError((Object)("Unexpected superinterface class: " + superinterface.getClass()));
            }
            for (Object typeVariableName : this.typeVariableNames) {
                if (typeVariableName instanceof XTypeName) {
                    builder.addTypeVariable((XTypeName)typeVariableName);
                    continue;
                }
                if (typeVariableName instanceof TypeVariableName) {
                    XConverters.toJavaPoet((XTypeSpec.Builder)builder).addTypeVariable((TypeVariableName)typeVariableName);
                    continue;
                }
                throw new AssertionError((Object)("Unexpected typeVariableName class: " + typeVariableName.getClass()));
            }
            for (Object annotation : this.annotations) {
                if (annotation instanceof XAnnotationSpec) {
                    builder.addAnnotation((XAnnotationSpec)annotation);
                    continue;
                }
                if (annotation instanceof AnnotationSpec) {
                    XConverters.toJavaPoet((XTypeSpec.Builder)builder).addAnnotation((AnnotationSpec)annotation);
                    continue;
                }
                throw new AssertionError((Object)("Unexpected annotation class: " + annotation.getClass()));
            }
            for (Object type : this.types) {
                if (type instanceof XTypeSpec) {
                    builder.addType((XTypeSpec)type);
                    continue;
                }
                if (type instanceof TypeSpec) {
                    XConverters.toJavaPoet((XTypeSpec.Builder)builder).addType((TypeSpec)type);
                    continue;
                }
                throw new AssertionError((Object)("Unexpected type class: " + type.getClass()));
            }
            for (Object property : this.properties) {
                if (property instanceof XPropertySpec) {
                    builder.addProperty((XPropertySpec)property);
                    continue;
                }
                if (property instanceof FieldSpec) {
                    XConverters.toJavaPoet((XTypeSpec.Builder)builder).addField((FieldSpec)property);
                    continue;
                }
                throw new AssertionError((Object)("Unexpected property class: " + property.getClass()));
            }
            for (Object function : this.functions) {
                if (function instanceof XFunSpec) {
                    builder.addFunction((XFunSpec)function);
                    continue;
                }
                if (function instanceof MethodSpec) {
                    XConverters.toJavaPoet((XTypeSpec.Builder)builder).addMethod((MethodSpec)function);
                    continue;
                }
                throw new AssertionError((Object)("Unexpected function class: " + function.getClass()));
            }
            return builder.build();
        }

        private static enum Kind {
            CLASS,
            INTERFACE,
            ANNOTATION,
            OBJECT,
            ANONYMOUS_CLASS;

        }
    }
}

