/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.AssistedInjectionBinding;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.InjectionBinding;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XParameterSpecs;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

final class InjectionMethods {
    InjectionMethods() {
    }

    private static XCodeBlock invokeMethod(String methodName, ImmutableList<XCodeBlock> parameters, XClassName enclosingClass, XClassName requestingClass) {
        XCodeBlock parameterBlock = XCodeBlocks.makeParametersCodeBlock(parameters);
        return enclosingClass.equals((Object)requestingClass) ? XCodeBlock.of((String)"%L(%L)", (Object[])new Object[]{methodName, parameterBlock}) : XCodeBlock.of((String)"%T.%L(%L)", (Object[])new Object[]{enclosingClass, methodName, parameterBlock});
    }

    static XCodeBlock copyParameters(XFunSpecs.Builder methodBuilder, UniqueNameSet parameterNameSet, List<? extends XVariableElement> parameters) {
        return parameters.stream().map(parameter -> {
            String name = parameterNameSet.getUniqueName(XElementKt.isMethodParameter((XElement)parameter) ? XElements.asMethodParameter((XElement)parameter).getJvmName() : XElements.getSimpleName((XElement)parameter));
            boolean useObject = !Accessibility.isRawTypePubliclyAccessible(parameter.getType());
            return InjectionMethods.copyParameter(methodBuilder, parameter.getType(), name, useObject, Nullability.of((XElement)parameter));
        }).collect(XCodeBlocks.toParametersCodeBlock());
    }

    static XCodeBlock copyParameter(XFunSpecs.Builder methodBuilder, XType type, String name, boolean useObject, Nullability nullability) {
        XTypeName typeName = XTypeNames.withTypeNullability(useObject ? XTypeName.ANY_OBJECT : type.asTypeName(), nullability);
        methodBuilder.addParameter(XParameterSpecs.of(name, typeName, nullability));
        return useObject ? XCodeBlock.ofCast((XTypeName)type.asTypeName(), (XCodeBlock)XCodeBlock.of((String)"%L", (Object[])new Object[]{name})) : XCodeBlock.of((String)"%L", (Object[])new Object[]{name});
    }

    static final class InjectionSiteMethod {
        InjectionSiteMethod() {
        }

        static XCodeBlock invokeAll(ImmutableSet<MembersInjectionBinding.InjectionSite> injectionSites, XClassName generatedTypeName, XCodeBlock instanceCodeBlock, XType instanceType, Function<DependencyRequest, XCodeBlock> dependencyUsage) {
            return injectionSites.stream().map(injectionSite -> {
                XType injectSiteType = injectionSite.enclosingTypeElement().getType();
                XCodeBlock maybeCastedInstance = instanceType.getTypeName().equals((Object)TypeName.OBJECT) && Accessibility.isRawTypeAccessible(injectSiteType, generatedTypeName.getPackageName()) ? XCodeBlock.ofCast((XTypeName)XConverters.toXPoet((TypeName)XTypes.erasedTypeName(injectSiteType)), (XCodeBlock)instanceCodeBlock) : instanceCodeBlock;
                return XCodeBlock.of((String)"%L;", (Object[])new Object[]{InjectionSiteMethod.invoke(injectionSite, generatedTypeName, maybeCastedInstance, dependencyUsage)});
            }).collect(XCodeBlocks.toConcatenatedCodeBlock());
        }

        private static XCodeBlock invoke(MembersInjectionBinding.InjectionSite injectionSite, XClassName generatedTypeName, XCodeBlock instanceCodeBlock, Function<DependencyRequest, XCodeBlock> dependencyUsage) {
            ImmutableList arguments = ImmutableList.builder().add((Object)instanceCodeBlock).addAll((Iterable)injectionSite.dependencies().stream().map(dependencyUsage).collect(DaggerStreams.toImmutableList())).build();
            XClassName enclosingClass = SourceFiles.membersInjectorNameForType(injectionSite.enclosingTypeElement());
            String methodName = SourceFiles.membersInjectorMethodName(injectionSite);
            return InjectionMethods.invokeMethod(methodName, (ImmutableList<XCodeBlock>)arguments, enclosingClass, generatedTypeName);
        }
    }

    static final class ProvisionMethod {
        ProvisionMethod() {
        }

        static XCodeBlock invoke(ContributionBinding binding, Function<DependencyRequest, XCodeBlock> dependencyUsage, Function<XExecutableParameterElement, String> uniqueAssistedParameterName, XClassName requestingClass, Optional<XCodeBlock> moduleReference, CompilerOptions compilerOptions) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            moduleReference.ifPresent(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
            ProvisionMethod.invokeArguments(binding, dependencyUsage, uniqueAssistedParameterName).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
            XClassName enclosingClass = SourceFiles.generatedClassNameForBinding(binding);
            String methodName = SourceFiles.generatedProxyMethodName(binding);
            return InjectionMethods.invokeMethod(methodName, (ImmutableList<XCodeBlock>)arguments.build(), enclosingClass, requestingClass);
        }

        static ImmutableList<XCodeBlock> invokeArguments(ContributionBinding binding, Function<DependencyRequest, XCodeBlock> dependencyUsage, Function<XExecutableParameterElement, String> uniqueAssistedParameterName) {
            ImmutableMap dependencyRequestMap = (ImmutableMap)ProvisionMethod.provisionDependencies(binding).stream().collect(DaggerStreams.toImmutableMap(request -> XElements.asMethodParameter(request.requestElement().get().xprocessing()), request -> request));
            ImmutableList.Builder arguments = ImmutableList.builder();
            XExecutableElement method = XElements.asExecutable(binding.bindingElement().get());
            for (XExecutableParameterElement parameter : method.getParameters()) {
                if (AssistedInjectionAnnotations.isAssistedParameter((XVariableElement)parameter)) {
                    arguments.add((Object)XCodeBlock.of((String)"%L", (Object[])new Object[]{uniqueAssistedParameterName.apply(parameter)}));
                    continue;
                }
                if (dependencyRequestMap.containsKey((Object)parameter)) {
                    DependencyRequest request2 = (DependencyRequest)dependencyRequestMap.get((Object)parameter);
                    arguments.add((Object)dependencyUsage.apply(request2));
                    continue;
                }
                throw new AssertionError((Object)("Unexpected parameter: " + parameter));
            }
            return arguments.build();
        }

        private static ImmutableSet<DependencyRequest> provisionDependencies(ContributionBinding binding) {
            switch (binding.kind()) {
                case INJECTION: {
                    return ((InjectionBinding)binding).constructorDependencies();
                }
                case ASSISTED_INJECTION: {
                    return ((AssistedInjectionBinding)binding).constructorDependencies();
                }
                case PROVISION: {
                    return ((ProvisionBinding)binding).dependencies();
                }
            }
            throw new AssertionError((Object)("Unexpected binding kind: " + (Object)((Object)binding.kind())));
        }
    }
}

