/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.FieldSpec;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.FrameworkField;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.FrameworkInstanceSupplier;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.internal.codegen.xprocessing.XAnnotationSpecs;
import dagger.internal.codegen.xprocessing.XPropertySpecs;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.Optional;
import javax.lang.model.element.Modifier;

class FrameworkFieldInitializer
implements FrameworkInstanceSupplier {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final ContributionBinding binding;
    private final FrameworkInstanceCreationExpression frameworkInstanceCreationExpression;
    private XPropertySpec propertySpec;
    private InitializationState fieldInitializationState = InitializationState.UNINITIALIZED;

    FrameworkFieldInitializer(ComponentImplementation componentImplementation, ContributionBinding binding, FrameworkInstanceCreationExpression frameworkInstanceCreationExpression) {
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.shardImplementation = ((ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation)).shardImplementation(binding);
        this.frameworkInstanceCreationExpression = (FrameworkInstanceCreationExpression)Preconditions.checkNotNull((Object)frameworkInstanceCreationExpression);
    }

    @Override
    public final MemberSelect memberSelect() {
        this.initializeField();
        return MemberSelect.localField(this.shardImplementation, ((FieldSpec)Preconditions.checkNotNull((Object)XConverters.toJavaPoet((XPropertySpec)this.propertySpec))).name);
    }

    private void initializeField() {
        switch (this.fieldInitializationState.ordinal()) {
            case 0: {
                this.fieldInitializationState = InitializationState.INITIALIZING;
                XCodeBlock.Builder codeBuilder = XCodeBlock.builder();
                XCodeBlock fieldInitialization = this.frameworkInstanceCreationExpression.creationExpression();
                XCodeBlock initCode = XCodeBlock.of((String)"this.%N = %L;", (Object[])new Object[]{this.getOrCreateField(), fieldInitialization});
                if (this.fieldInitializationState == InitializationState.DELEGATED) {
                    codeBuilder.add("%T.setDelegate(%N, %L);", new Object[]{this.delegateType(), this.propertySpec, fieldInitialization});
                } else {
                    codeBuilder.add(initCode);
                }
                this.shardImplementation.addInitialization(codeBuilder.build());
                this.fieldInitializationState = InitializationState.INITIALIZED;
                break;
            }
            case 1: {
                this.propertySpec = this.getOrCreateField();
                this.fieldInitializationState = InitializationState.DELEGATED;
                this.shardImplementation.addInitialization(XCodeBlock.of((String)"this.%N = new %T<>();", (Object[])new Object[]{this.propertySpec, this.delegateType()}));
                break;
            }
        }
    }

    private XPropertySpec getOrCreateField() {
        XTypeName fieldType;
        if (this.propertySpec != null) {
            return this.propertySpec;
        }
        boolean useRawType = !this.shardImplementation.isTypeAccessible(this.binding.key().type().xprocessing());
        FrameworkField contributionBindingField = FrameworkField.forBinding(this.binding, this.frameworkInstanceCreationExpression.alternativeFrameworkClass());
        XTypeName xTypeName = fieldType = useRawType ? contributionBindingField.type().getRawTypeName() : contributionBindingField.type();
        if (this.binding.kind() == BindingKind.ASSISTED_INJECTION) {
            XTypeName[] typeParameters = (XTypeName[])this.binding.key().type().xprocessing().getTypeArguments().stream().map(XType::asTypeName).toArray(XTypeName[]::new);
            fieldType = typeParameters.length == 0 ? SourceFiles.generatedClassNameForBinding(this.binding) : SourceFiles.generatedClassNameForBinding(this.binding).parametrizedBy(typeParameters);
        }
        XPropertySpecs.Builder contributionField = XPropertySpecs.builder(this.shardImplementation.getUniqueFieldName(contributionBindingField.name()), fieldType, new Modifier[0]);
        if (!this.shardImplementation.isShardClassPrivate()) {
            contributionField.addModifiers(Modifier.PRIVATE);
        }
        if (useRawType) {
            contributionField.addAnnotation(XAnnotationSpecs.suppressWarnings(XAnnotationSpecs.Suppression.RAWTYPES, new XAnnotationSpecs.Suppression[0]));
        }
        this.propertySpec = contributionField.build();
        this.shardImplementation.addField(ComponentImplementation.FieldSpecKind.FRAMEWORK_FIELD, this.propertySpec);
        return this.propertySpec;
    }

    private XClassName delegateType() {
        return this.isProvider() ? XTypeNames.DELEGATE_FACTORY : XTypeNames.DELEGATE_PRODUCER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isProvider() {
        if (!this.binding.bindingType().equals((Object)BindingType.PROVISION)) return false;
        if (this.frameworkInstanceCreationExpression.alternativeFrameworkClass().map(arg_0 -> ((XClassName)XTypeNames.PROVIDER).equals(arg_0)).orElse(true) == false) return false;
        return true;
    }

    private static enum InitializationState {
        UNINITIALIZED,
        INITIALIZING,
        DELEGATED,
        INITIALIZED;

    }

    static interface FrameworkInstanceCreationExpression {
        public XCodeBlock creationExpression();

        default public Optional<XClassName> alternativeFrameworkClass() {
            return Optional.empty();
        }
    }
}

