/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.model;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.Binding;
import dagger.internal.codegen.model.ComponentPath;
import dagger.internal.codegen.model.DaggerExecutableElement;
import dagger.internal.codegen.model.DaggerTypeElement;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.Scope;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public abstract class BindingGraph {
    private static final ImmutableSet<Class<? extends Node>> NODE_TYPES = ImmutableSet.of(Binding.class, MissingBinding.class, ComponentNode.class);

    public abstract ImmutableNetwork<Node, Edge> network();

    public String toString() {
        return this.network().toString();
    }

    @Deprecated
    public boolean isModuleBindingGraph() {
        return !this.rootComponentNode().isRealComponent();
    }

    public abstract boolean isFullBindingGraph();

    @Deprecated
    public boolean isPartialBindingGraph() {
        return this.rootComponentNode().isSubcomponent();
    }

    public ImmutableSet<Binding> bindings() {
        return this.nodes(Binding.class);
    }

    public ImmutableSet<Binding> bindings(Key key) {
        return (ImmutableSet)this.nodes(Binding.class).stream().filter(binding -> binding.key().equals(key)).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<MissingBinding> missingBindings() {
        return this.nodes(MissingBinding.class);
    }

    public ImmutableSet<ComponentNode> componentNodes() {
        return this.nodes(ComponentNode.class);
    }

    public Optional<ComponentNode> componentNode(ComponentPath component) {
        return this.componentNodes().stream().filter(node -> node.componentPath().equals(component)).findFirst();
    }

    public ImmutableSet<ComponentNode> componentNodes(DaggerTypeElement component) {
        return (ImmutableSet)this.componentNodes().stream().filter(node -> node.componentPath().currentComponent().equals(component)).collect(DaggerStreams.toImmutableSet());
    }

    public ComponentNode rootComponentNode() {
        return this.componentNodes().stream().filter(node -> node.componentPath().atRoot()).findFirst().get();
    }

    public ImmutableSet<DependencyEdge> dependencyEdges() {
        return (ImmutableSet)this.dependencyEdgeStream().collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSetMultimap<DependencyRequest, DependencyEdge> dependencyEdges(Binding binding) {
        return (ImmutableSetMultimap)this.dependencyEdgeStream(binding).collect(DaggerStreams.toImmutableSetMultimap(DependencyEdge::dependencyRequest, edge -> edge));
    }

    public ImmutableSet<DependencyEdge> dependencyEdges(DependencyRequest dependencyRequest) {
        return (ImmutableSet)this.dependencyEdgeStream().filter(edge -> edge.dependencyRequest().equals(dependencyRequest)).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<DependencyEdge> entryPointEdges(ComponentPath component) {
        return (ImmutableSet)this.dependencyEdgeStream(this.componentNode(component).get()).collect(DaggerStreams.toImmutableSet());
    }

    private Stream<DependencyEdge> dependencyEdgeStream(Node node) {
        return this.network().outEdges((Object)node).stream().flatMap(DaggerStreams.instancesOf(DependencyEdge.class));
    }

    public ImmutableSet<DependencyEdge> entryPointEdges() {
        return (ImmutableSet)this.entryPointEdgeStream().collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<MaybeBinding> entryPointBindings() {
        return (ImmutableSet)this.entryPointEdgeStream().map(edge -> (MaybeBinding)this.network().incidentNodes(edge).target()).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<DependencyEdge> entryPointEdgesDependingOnBinding(MaybeBinding binding) {
        ImmutableNetwork<Node, DependencyEdge> dependencyGraph = this.dependencyGraph();
        MutableNetwork subgraphDependingOnBinding = Graphs.inducedSubgraph(dependencyGraph, (Iterable)Graphs.reachableNodes((Graph)Graphs.transpose(dependencyGraph).asGraph(), (Object)binding));
        return Sets.intersection(this.entryPointEdges(), (Set)subgraphDependingOnBinding.edges()).immutableCopy();
    }

    public ImmutableSet<Binding> requestingBindings(MaybeBinding binding) {
        return (ImmutableSet)this.network().predecessors((Object)binding).stream().flatMap(DaggerStreams.instancesOf(Binding.class)).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<Binding> requestedBindings(Binding binding) {
        return (ImmutableSet)this.network().successors((Object)binding).stream().flatMap(DaggerStreams.instancesOf(Binding.class)).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<MaybeBinding> requestedMaybeMissingBindings(Binding binding) {
        return (ImmutableSet)this.network().successors((Object)binding).stream().flatMap(DaggerStreams.instancesOf(MaybeBinding.class)).collect(DaggerStreams.toImmutableSet());
    }

    protected ImmutableNetwork<Node, DependencyEdge> dependencyGraph() {
        MutableNetwork dependencyGraph = NetworkBuilder.from(this.network()).expectedNodeCount(this.network().nodes().size()).expectedEdgeCount((int)this.dependencyEdgeStream().count()).build();
        this.network().nodes().forEach(arg_0 -> ((MutableNetwork)dependencyGraph).addNode(arg_0));
        this.dependencyEdgeStream().forEach(edge -> {
            EndpointPair endpoints = this.network().incidentNodes(edge);
            dependencyGraph.addEdge((Object)((Node)endpoints.source()), (Object)((Node)endpoints.target()), edge);
        });
        return ImmutableNetwork.copyOf((Network)dependencyGraph);
    }

    private <N extends Node> ImmutableSet<N> nodes(Class<N> clazz) {
        return this.nodesByClass().get(clazz);
    }

    protected ImmutableSetMultimap<Class<? extends Node>, ? extends Node> nodesByClass() {
        return (ImmutableSetMultimap)this.network().nodes().stream().collect(DaggerStreams.toImmutableSetMultimap(node -> NODE_TYPES.stream().filter(clazz -> clazz.isInstance(node)).findFirst().get(), node -> node));
    }

    private Stream<DependencyEdge> dependencyEdgeStream() {
        return this.network().edges().stream().flatMap(DaggerStreams.instancesOf(DependencyEdge.class));
    }

    private Stream<DependencyEdge> entryPointEdgeStream() {
        return this.dependencyEdgeStream().filter(DependencyEdge::isEntryPoint);
    }

    public static interface ComponentNode
    extends Node {
        @Override
        public ComponentPath componentPath();

        public boolean isSubcomponent();

        public boolean isRealComponent();

        public ImmutableSet<DependencyRequest> entryPoints();

        public ImmutableSet<Scope> scopes();
    }

    public static abstract class MissingBinding
    implements MaybeBinding {
        @Override
        public abstract ComponentPath componentPath();

        @Override
        public abstract Key key();

        @Override
        @Deprecated
        public Optional<Binding> binding() {
            return Optional.empty();
        }

        public String toString() {
            return String.format("missing binding for %s in %s", this.key(), this.componentPath());
        }
    }

    public static interface Node {
        public ComponentPath componentPath();
    }

    public static interface DependencyEdge
    extends Edge {
        public DependencyRequest dependencyRequest();

        public boolean isEntryPoint();
    }

    public static interface MaybeBinding
    extends Node {
        @Override
        public ComponentPath componentPath();

        public Key key();

        public Optional<Binding> binding();
    }

    public static interface SubcomponentCreatorBindingEdge
    extends Edge {
        public ImmutableSet<DaggerTypeElement> declaringModules();
    }

    public static interface ChildFactoryMethodEdge
    extends Edge {
        public DaggerExecutableElement factoryMethod();
    }

    public static interface Edge {
    }
}

