/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.Optional;
import javax.lang.model.element.Modifier;

final class ProducerEntryPointView {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final XProcessingEnv processingEnv;

    ProducerEntryPointView(ComponentImplementation.ShardImplementation shardImplementation, XProcessingEnv processingEnv) {
        this.shardImplementation = shardImplementation;
        this.processingEnv = processingEnv;
    }

    Optional<Expression> getProducerEntryPointField(RequestRepresentation producerExpression, ComponentDescriptor.ComponentMethodDescriptor componentMethod, ClassName requestingClass) {
        if (this.shardImplementation.componentDescriptor().isProduction() && (componentMethod.dependencyRequest().get().kind().equals((Object)RequestKind.FUTURE) || componentMethod.dependencyRequest().get().kind().equals((Object)RequestKind.PRODUCER))) {
            MemberSelect field = this.createField(producerExpression, componentMethod);
            return Optional.of(Expression.create(this.fieldType(componentMethod), field.getExpressionFor(requestingClass)));
        }
        return Optional.empty();
    }

    private MemberSelect createField(RequestRepresentation producerExpression, ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        String methodName = XElements.getSimpleName((XElement)componentMethod.methodElement());
        FieldSpec field = FieldSpec.builder((TypeName)this.fieldType(componentMethod).getTypeName(), (String)this.shardImplementation.getUniqueFieldName(methodName + "EntryPoint"), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        this.shardImplementation.addField(ComponentImplementation.FieldSpecKind.FRAMEWORK_FIELD, field);
        CodeBlock fieldInitialization = CodeBlock.of((String)"this.$N = $T.entryPointViewOf($L, $L);", (Object[])new Object[]{field, TypeNames.PRODUCERS, producerExpression.getDependencyExpression(this.shardImplementation.name()).codeBlock(), this.shardImplementation.isComponentShard() ? "this" : this.shardImplementation.getComponentImplementation().getComponentShard().shardFieldReference()});
        this.shardImplementation.addInitialization(fieldInitialization);
        return MemberSelect.localField(this.shardImplementation, field.name);
    }

    private XType fieldType(ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        return XProcessingEnvs.wrapType(TypeNames.PRODUCER, componentMethod.dependencyRequest().get().key().type().xprocessing(), this.processingEnv);
    }
}

