/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Traverser;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import dagger.internal.codegen.base.ElementFormatter;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.validation.AutoValue_ValidationReport_Item;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Optional;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public final class ValidationReport {
    private static final Traverser<ValidationReport> SUBREPORTS = Traverser.forTree(report -> report.subreports);
    private final Element subject;
    private final ImmutableSet<Item> items;
    private final ImmutableSet<ValidationReport> subreports;
    private final boolean markedDirty;
    private boolean hasPrintedErrors;

    private ValidationReport(Element subject, ImmutableSet<Item> items, ImmutableSet<ValidationReport> subreports, boolean markedDirty) {
        this.subject = subject;
        this.items = items;
        this.subreports = subreports;
        this.markedDirty = markedDirty;
    }

    public ImmutableSet<Item> allItems() {
        return (ImmutableSet)ImmutableSet.copyOf((Iterable)SUBREPORTS.depthFirstPreOrder((Object)this)).stream().flatMap(report -> report.items.stream()).collect(DaggerStreams.toImmutableSet());
    }

    public boolean isClean() {
        if (this.markedDirty) {
            return false;
        }
        for (Item item : this.items) {
            switch (item.kind()) {
                case ERROR: {
                    return false;
                }
            }
        }
        for (ValidationReport subreport : this.subreports) {
            if (subreport.isClean()) continue;
            return false;
        }
        return true;
    }

    public void printMessagesTo(XMessager messager) {
        this.printMessagesTo(XConverters.toJavac((XMessager)messager));
    }

    public void printMessagesTo(Messager messager) {
        if (this.hasPrintedErrors) {
            return;
        }
        this.hasPrintedErrors = true;
        for (Item item : this.items) {
            if (DaggerElements.transitivelyEncloses(this.subject, item.element())) {
                if (item.annotation().isPresent()) {
                    if (item.annotationValue().isPresent()) {
                        messager.printMessage(item.kind(), item.message(), item.element(), item.annotation().get(), item.annotationValue().get());
                        continue;
                    }
                    messager.printMessage(item.kind(), item.message(), item.element(), item.annotation().get());
                    continue;
                }
                messager.printMessage(item.kind(), item.message(), item.element());
                continue;
            }
            String message = String.format("[%s] %s", ElementFormatter.elementToString(item.element()), item.message());
            messager.printMessage(item.kind(), message, this.subject);
        }
        for (ValidationReport subreport : this.subreports) {
            subreport.printMessagesTo(messager);
        }
    }

    public static Builder about(Element subject) {
        return new Builder(subject);
    }

    public static Builder about(XElement subject) {
        return new Builder(XConverters.toJavac((XElement)subject));
    }

    @CanIgnoreReturnValue
    public static final class Builder {
        private final Element subject;
        private final ImmutableSet.Builder<Item> items = ImmutableSet.builder();
        private final ImmutableSet.Builder<ValidationReport> subreports = ImmutableSet.builder();
        private boolean markedDirty;

        private Builder(Element subject) {
            this.subject = subject;
        }

        Builder addItems(Iterable<Item> newItems) {
            this.items.addAll(newItems);
            return this;
        }

        public Builder addError(String message) {
            return this.addError(message, this.subject);
        }

        public Builder addError(String message, Element element) {
            return this.addItem(message, Diagnostic.Kind.ERROR, element);
        }

        public Builder addError(String message, Element element, AnnotationMirror annotation) {
            return this.addItem(message, Diagnostic.Kind.ERROR, element, annotation);
        }

        public Builder addError(String message, Element element, AnnotationMirror annotation, AnnotationValue annotationValue) {
            return this.addItem(message, Diagnostic.Kind.ERROR, element, annotation, annotationValue);
        }

        public Builder addError(String message, XElement element) {
            return this.addItem(message, Diagnostic.Kind.ERROR, element);
        }

        public Builder addError(String message, XElement element, XAnnotation annotation) {
            return this.addItem(message, Diagnostic.Kind.ERROR, element, annotation);
        }

        public Builder addError(String message, XElement element, XAnnotation annotation, XAnnotationValue annotationValue) {
            return this.addItem(message, Diagnostic.Kind.ERROR, element, annotation, annotationValue);
        }

        Builder addWarning(String message) {
            return this.addWarning(message, this.subject);
        }

        Builder addWarning(String message, Element element) {
            return this.addItem(message, Diagnostic.Kind.WARNING, element);
        }

        Builder addWarning(String message, Element element, AnnotationMirror annotation) {
            return this.addItem(message, Diagnostic.Kind.WARNING, element, annotation);
        }

        Builder addWarning(String message, Element element, AnnotationMirror annotation, AnnotationValue annotationValue) {
            return this.addItem(message, Diagnostic.Kind.WARNING, element, annotation, annotationValue);
        }

        Builder addWarning(String message, XElement element) {
            return this.addItem(message, Diagnostic.Kind.WARNING, element);
        }

        Builder addWarning(String message, XElement element, XAnnotation annotation) {
            return this.addItem(message, Diagnostic.Kind.WARNING, element, annotation);
        }

        Builder addWarning(String message, XElement element, XAnnotation annotation, XAnnotationValue annotationValue) {
            return this.addItem(message, Diagnostic.Kind.WARNING, element, annotation, annotationValue);
        }

        Builder addNote(String message) {
            return this.addNote(message, this.subject);
        }

        Builder addNote(String message, Element element) {
            return this.addItem(message, Diagnostic.Kind.NOTE, element);
        }

        Builder addNote(String message, Element element, AnnotationMirror annotation) {
            return this.addItem(message, Diagnostic.Kind.NOTE, element, annotation);
        }

        Builder addNote(String message, Element element, AnnotationMirror annotation, AnnotationValue annotationValue) {
            return this.addItem(message, Diagnostic.Kind.NOTE, element, annotation, annotationValue);
        }

        Builder addNote(String message, XElement element) {
            return this.addItem(message, Diagnostic.Kind.NOTE, element);
        }

        Builder addNote(String message, XElement element, XAnnotation annotation) {
            return this.addItem(message, Diagnostic.Kind.NOTE, element, annotation);
        }

        Builder addNote(String message, XElement element, XAnnotation annotation, XAnnotationValue annotationValue) {
            return this.addItem(message, Diagnostic.Kind.NOTE, element, annotation, annotationValue);
        }

        Builder addItem(String message, Diagnostic.Kind kind, Element element) {
            return this.addItem(message, kind, element, Optional.empty(), Optional.empty());
        }

        Builder addItem(String message, Diagnostic.Kind kind, Element element, AnnotationMirror annotation) {
            return this.addItem(message, kind, element, Optional.of(annotation), Optional.empty());
        }

        Builder addItem(String message, Diagnostic.Kind kind, Element element, AnnotationMirror annotation, AnnotationValue annotationValue) {
            return this.addItem(message, kind, element, Optional.of(annotation), Optional.of(annotationValue));
        }

        private Builder addItem(String message, Diagnostic.Kind kind, Element element, Optional<AnnotationMirror> annotation, Optional<AnnotationValue> annotationValue) {
            this.items.add((Object)new AutoValue_ValidationReport_Item(message, kind, element, annotation, annotationValue));
            return this;
        }

        Builder addItem(String message, Diagnostic.Kind kind, XElement element) {
            return this.addItem(message, kind, element, Optional.empty(), Optional.empty());
        }

        Builder addItem(String message, Diagnostic.Kind kind, XElement element, XAnnotation annotation) {
            return this.addItem(message, kind, element, Optional.of(annotation), Optional.empty());
        }

        Builder addItem(String message, Diagnostic.Kind kind, XElement element, XAnnotation annotation, XAnnotationValue annotationValue) {
            return this.addItem(message, kind, element, Optional.of(annotation), Optional.of(annotationValue));
        }

        private Builder addItem(String message, Diagnostic.Kind kind, XElement element, Optional<XAnnotation> annotation, Optional<XAnnotationValue> annotationValue) {
            this.items.add((Object)new AutoValue_ValidationReport_Item(message, kind, XConverters.toJavac((XElement)element), annotation.map(XConverters::toJavac), annotationValue.map(XConverters::toJavac)));
            return this;
        }

        void markDirty() {
            this.markedDirty = true;
        }

        public Builder addSubreport(ValidationReport subreport) {
            this.subreports.add((Object)subreport);
            return this;
        }

        @CheckReturnValue
        public ValidationReport build() {
            return new ValidationReport(this.subject, this.items.build(), this.subreports.build(), this.markedDirty);
        }
    }

    @AutoValue
    public static abstract class Item {
        public abstract String message();

        public abstract Diagnostic.Kind kind();

        public abstract Element element();

        public abstract Optional<AnnotationMirror> annotation();

        abstract Optional<AnnotationValue> annotationValue();
    }
}

