/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreElements;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public enum ModuleKind {
    MODULE(TypeNames.MODULE),
    PRODUCER_MODULE(TypeNames.PRODUCER_MODULE);

    private final ClassName moduleAnnotation;

    public static ImmutableSet<ClassName> annotationsFor(Set<ModuleKind> kinds) {
        return (ImmutableSet)kinds.stream().map(ModuleKind::annotation).collect(DaggerStreams.toImmutableSet());
    }

    public static Optional<ModuleKind> forAnnotatedElement(XTypeElement element) {
        return ModuleKind.forAnnotatedElement(XConverters.toJavac((XTypeElement)element));
    }

    public static Optional<ModuleKind> forAnnotatedElement(TypeElement element) {
        EnumSet<ModuleKind> kinds = EnumSet.noneOf(ModuleKind.class);
        for (ModuleKind kind : ModuleKind.values()) {
            if (!DaggerElements.isAnnotationPresent((Element)element, kind.annotation())) continue;
            kinds.add(kind);
        }
        if (kinds.size() > 1) {
            throw new IllegalArgumentException(element + " cannot be annotated with more than one of " + ModuleKind.annotationsFor(kinds));
        }
        return kinds.stream().findAny();
    }

    public static void checkIsModule(XTypeElement moduleElement) {
        if (moduleElement.isCompanionObject()) {
            Preconditions.checkArgument((boolean)ModuleKind.forAnnotatedElement(moduleElement.getEnclosingTypeElement()).isPresent());
        } else {
            Preconditions.checkArgument((boolean)ModuleKind.forAnnotatedElement(moduleElement).isPresent());
        }
    }

    public static void checkIsModule(TypeElement moduleElement, KotlinMetadataUtil metadataUtil) {
        if (metadataUtil.isCompanionObjectClass(moduleElement)) {
            Preconditions.checkArgument((boolean)ModuleKind.forAnnotatedElement(MoreElements.asType((Element)moduleElement.getEnclosingElement())).isPresent());
        } else {
            Preconditions.checkArgument((boolean)ModuleKind.forAnnotatedElement(moduleElement).isPresent());
        }
    }

    private ModuleKind(ClassName moduleAnnotation) {
        this.moduleAnnotation = moduleAnnotation;
    }

    public XAnnotation getModuleAnnotation(XTypeElement element) {
        Preconditions.checkArgument((boolean)element.hasAnnotation(this.moduleAnnotation), (String)"annotation %s is not present on type %s", (Object)this.moduleAnnotation, (Object)element);
        return element.getAnnotation(this.moduleAnnotation);
    }

    public ClassName annotation() {
        return this.moduleAnnotation;
    }

    public ImmutableSet<ModuleKind> legalIncludedModuleKinds() {
        switch (this) {
            case MODULE: {
                return Sets.immutableEnumSet((Enum)MODULE, (Enum[])new ModuleKind[0]);
            }
            case PRODUCER_MODULE: {
                return Sets.immutableEnumSet((Enum)MODULE, (Enum[])new ModuleKind[]{PRODUCER_MODULE});
            }
        }
        throw new AssertionError((Object)this);
    }
}

