/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.Key;
import dagger.spi.shaded.auto.common.MoreTypes;
import java.util.Iterator;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.SimpleTypeVisitor8;

public final class KeyVariableNamer {
    private static final ImmutableSet<String> VERY_SIMPLE_NAMES = ImmutableSet.of((Object)"Builder", (Object)"Factory", (Object)"Component", (Object)"Subcomponent", (Object)"Injector");
    private static final TypeVisitor<Void, StringBuilder> TYPE_NAMER = new SimpleTypeVisitor8<Void, StringBuilder>(){

        @Override
        public Void visitDeclared(DeclaredType declaredType, StringBuilder builder) {
            TypeElement element = MoreTypes.asTypeElement((TypeMirror)declaredType);
            if (element.getNestingKind().isNested() && VERY_SIMPLE_NAMES.contains((Object)element.getSimpleName().toString())) {
                builder.append(element.getEnclosingElement().getSimpleName());
            }
            builder.append(element.getSimpleName());
            Iterator<? extends TypeMirror> argumentIterator = declaredType.getTypeArguments().iterator();
            if (argumentIterator.hasNext()) {
                builder.append("Of");
                TypeMirror first = argumentIterator.next();
                first.accept(this, builder);
                while (argumentIterator.hasNext()) {
                    builder.append("And");
                    argumentIterator.next().accept(this, builder);
                }
            }
            return null;
        }

        @Override
        public Void visitPrimitive(PrimitiveType type, StringBuilder builder) {
            builder.append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, type.toString()));
            return null;
        }

        @Override
        public Void visitArray(ArrayType type, StringBuilder builder) {
            type.getComponentType().accept(this, builder);
            builder.append("Array");
            return null;
        }
    };

    private KeyVariableNamer() {
    }

    public static String name(Key key) {
        if (key.multibindingContributionIdentifier().isPresent()) {
            return ((Key.MultibindingContributionIdentifier)key.multibindingContributionIdentifier().get()).bindingElement();
        }
        StringBuilder builder = new StringBuilder();
        if (key.qualifier().isPresent()) {
            builder.append(((DaggerAnnotation)key.qualifier().get()).java().getAnnotationType().asElement().getSimpleName());
        }
        key.type().java().accept(TYPE_NAMER, builder);
        return SourceFiles.protectAgainstKeywords(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, builder.toString()));
    }
}

