/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Equivalence;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.MoreAnnotationMirrors;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.Binding;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.Key;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreElements;
import java.util.Arrays;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeMirror;

public abstract class ContributionBinding
extends Binding
implements ContributionType.HasContributionType {
    public abstract Optional<XType> nullableType();

    public abstract Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedMapKeyAnnotation();

    public final Optional<AnnotationMirror> mapKeyAnnotation() {
        return MoreAnnotationMirrors.unwrapOptionalEquivalence(this.wrappedMapKeyAnnotation());
    }

    public final Optional<TypeMirror> contributedPrimitiveType() {
        return this.bindingElement().map(XConverters::toJavac).filter(bindingElement -> bindingElement.getKind() == ElementKind.METHOD).map(bindingElement -> MoreElements.asExecutable((Element)bindingElement).getReturnType()).filter(type -> type.getKind().isPrimitive());
    }

    @Override
    public boolean requiresModuleInstance() {
        return !this.isContributingModuleKotlinObject() && super.requiresModuleInstance();
    }

    @Override
    public final boolean isNullable() {
        return this.nullableType().isPresent();
    }

    private boolean isContributingModuleKotlinObject() {
        return this.contributingModule().isPresent() && (this.contributingModule().get().isKotlinObject() || this.contributingModule().get().isCompanionObject());
    }

    public final TypeMirror contributedType() {
        switch (this.contributionType()) {
            case MAP: {
                return XConverters.toJavac((XType)MapType.from(this.key()).unwrappedFrameworkValueType());
            }
            case SET: {
                return XConverters.toJavac((XType)SetType.from(this.key()).elementType());
            }
            case SET_VALUES: 
            case UNIQUE: {
                return this.key().type().java();
            }
        }
        throw new AssertionError();
    }

    public abstract Builder<?, ?> toBuilder();

    @CanIgnoreReturnValue
    public static abstract class Builder<C extends ContributionBinding, B extends Builder<C, B>> {
        public abstract B dependencies(Iterable<DependencyRequest> var1);

        public B dependencies(DependencyRequest ... dependencies) {
            return this.dependencies(Arrays.asList(dependencies));
        }

        public abstract B unresolved(C var1);

        public abstract B contributionType(ContributionType var1);

        public abstract B bindingElement(XElement var1);

        abstract B bindingElement(Optional<XElement> var1);

        public final B clearBindingElement() {
            return this.bindingElement(Optional.empty());
        }

        abstract B contributingModule(XTypeElement var1);

        public abstract B key(Key var1);

        public abstract B nullableType(Optional<XType> var1);

        abstract B wrappedMapKeyAnnotation(Optional<Equivalence.Wrapper<AnnotationMirror>> var1);

        public abstract B kind(BindingKind var1);

        @CheckReturnValue
        abstract C build();
    }
}

