/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.binding.AutoValue_ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentCreatorAnnotation;
import dagger.internal.codegen.binding.ComponentCreatorKind;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.DependencyRequestFactory;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.spi.model.DependencyRequest;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.List;
import java.util.Map;

@AutoValue
public abstract class ComponentCreatorDescriptor {
    public abstract ComponentCreatorAnnotation annotation();

    public final ComponentCreatorKind kind() {
        return this.annotation().creatorKind();
    }

    public abstract XTypeElement typeElement();

    public abstract XMethodElement factoryMethod();

    abstract ImmutableSetMultimap<ComponentRequirement, XMethodElement> unvalidatedSetterMethods();

    abstract ImmutableSetMultimap<ComponentRequirement, XExecutableParameterElement> unvalidatedFactoryParameters();

    public final ImmutableSetMultimap<ComponentRequirement, XElement> unvalidatedRequirementElements() {
        return ImmutableSetMultimap.copyOf(this.unvalidatedSetterMethods().isEmpty() ? this.unvalidatedFactoryParameters() : this.unvalidatedSetterMethods());
    }

    @Memoized
    ImmutableMap<ComponentRequirement, XElement> requirementElements() {
        return ComponentCreatorDescriptor.flatten(this.unvalidatedRequirementElements());
    }

    @Memoized
    public ImmutableMap<ComponentRequirement, XMethodElement> setterMethods() {
        return ComponentCreatorDescriptor.flatten(this.unvalidatedSetterMethods());
    }

    @Memoized
    public ImmutableMap<ComponentRequirement, XExecutableParameterElement> factoryParameters() {
        return ComponentCreatorDescriptor.flatten(this.unvalidatedFactoryParameters());
    }

    private static <K, V> ImmutableMap<K, V> flatten(Multimap<K, V> multimap) {
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)multimap.asMap(), values -> Iterables.getOnlyElement((Iterable)values)));
    }

    public final ImmutableSet<ComponentRequirement> userSettableRequirements() {
        return this.unvalidatedRequirementElements().keySet();
    }

    public final ImmutableSet<ComponentRequirement> moduleAndDependencyRequirements() {
        return (ImmutableSet)this.userSettableRequirements().stream().filter(requirement -> !requirement.isBoundInstance()).collect(DaggerStreams.toImmutableSet());
    }

    final ImmutableSet<ComponentRequirement> boundInstanceRequirements() {
        return (ImmutableSet)this.userSettableRequirements().stream().filter(ComponentRequirement::isBoundInstance).collect(DaggerStreams.toImmutableSet());
    }

    final XElement elementForRequirement(ComponentRequirement requirement) {
        return (XElement)this.requirementElements().get((Object)requirement);
    }

    public static ComponentCreatorDescriptor create(XTypeElement creator, DaggerTypes types, DependencyRequestFactory dependencyRequestFactory) {
        XType componentType = creator.getEnclosingTypeElement().getType();
        ImmutableSetMultimap.Builder setterMethods = ImmutableSetMultimap.builder();
        XMethodElement factoryMethod = null;
        for (XMethodElement method : XTypeElements.getAllUnimplementedMethods((XTypeElement)creator)) {
            XMethodType resolvedMethodType = method.asMemberOf(creator.getType());
            if (types.isSubtype(componentType, resolvedMethodType.getReturnType())) {
                Verify.verify((factoryMethod == null ? 1 : 0) != 0);
                factoryMethod = method;
                continue;
            }
            XExecutableParameterElement parameter = (XExecutableParameterElement)Iterables.getOnlyElement((Iterable)method.getParameters());
            XType parameterType = (XType)Iterables.getOnlyElement((Iterable)resolvedMethodType.getParameterTypes());
            setterMethods.put((Object)ComponentCreatorDescriptor.requirement(method, parameter, parameterType, dependencyRequestFactory, (XElement)method), (Object)method);
        }
        Verify.verify((factoryMethod != null ? 1 : 0) != 0);
        ImmutableSetMultimap.Builder factoryParameters = ImmutableSetMultimap.builder();
        XMethodType resolvedFactoryMethodType = factoryMethod.asMemberOf(creator.getType());
        List parameters = factoryMethod.getParameters();
        List parameterTypes = resolvedFactoryMethodType.getParameterTypes();
        for (int i = 0; i < parameters.size(); ++i) {
            XExecutableParameterElement parameter = (XExecutableParameterElement)parameters.get(i);
            XType parameterType = (XType)parameterTypes.get(i);
            factoryParameters.put((Object)ComponentCreatorDescriptor.requirement(factoryMethod, parameter, parameterType, dependencyRequestFactory, (XElement)parameter), (Object)parameter);
        }
        ComponentCreatorAnnotation annotation = (ComponentCreatorAnnotation)((Object)Iterables.getOnlyElement(ComponentCreatorAnnotation.getCreatorAnnotations(creator)));
        return new AutoValue_ComponentCreatorDescriptor(annotation, creator, factoryMethod, (ImmutableSetMultimap<ComponentRequirement, XMethodElement>)setterMethods.build(), (ImmutableSetMultimap<ComponentRequirement, XExecutableParameterElement>)factoryParameters.build());
    }

    private static ComponentRequirement requirement(XMethodElement method, XExecutableParameterElement parameter, XType parameterType, DependencyRequestFactory dependencyRequestFactory, XElement elementForVariableName) {
        if (method.hasAnnotation(TypeNames.BINDS_INSTANCE) || parameter.hasAnnotation(TypeNames.BINDS_INSTANCE)) {
            DependencyRequest request = dependencyRequestFactory.forRequiredResolvedVariable((XVariableElement)parameter, parameterType);
            return ComponentRequirement.forBoundInstance(request.key(), request.isNullable(), elementForVariableName);
        }
        return ModuleAnnotation.moduleAnnotation((XElement)parameterType.getTypeElement()).isPresent() ? ComponentRequirement.forModule(parameterType) : ComponentRequirement.forDependency(parameterType);
    }
}

