/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.Key;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class Keys {
    public static boolean isValidMembersInjectionKey(Key key) {
        return !key.qualifier().isPresent() && !key.multibindingContributionIdentifier().isPresent() && key.type().java().getKind().equals((Object)TypeKind.DECLARED);
    }

    public static boolean isValidImplicitProvisionKey(Key key, DaggerTypes types) {
        return Keys.isValidImplicitProvisionKey(key.qualifier().map(DaggerAnnotation::java), key.type().java(), types);
    }

    public static boolean isValidImplicitProvisionKey(Optional<XAnnotation> qualifier, XType type, DaggerTypes types) {
        return Keys.isValidImplicitProvisionKey(qualifier.map(XConverters::toJavac), XConverters.toJavac((XType)type), types);
    }

    public static boolean isValidImplicitProvisionKey(Optional<? extends AnnotationMirror> qualifier, TypeMirror type, DaggerTypes types) {
        if (qualifier.isPresent()) {
            return false;
        }
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        DeclaredType declaredType = MoreTypes.asDeclared((TypeMirror)type);
        if (!declaredType.asElement().getKind().equals((Object)ElementKind.CLASS) || declaredType.asElement().getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return false;
        }
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            if (typeMirror.getKind() == TypeKind.DECLARED) continue;
            return false;
        }
        DeclaredType definedType = declaredType;
        return definedType.getTypeArguments().isEmpty() || !types.isSameType(types.erasure(definedType), declaredType);
    }

    public static boolean isComponentOrCreator(Key key) {
        return !key.qualifier().isPresent() && key.type().java().getKind() == TypeKind.DECLARED && DaggerElements.isAnyAnnotationPresent(MoreTypes.asTypeElement((TypeMirror)key.type().java()), ComponentAnnotation.allComponentAndCreatorAnnotations());
    }
}

