/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.Preconditions;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.ConfigurationAnnotations;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.shaded.auto.common.MoreElements;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.DaggerElement;
import dagger.spi.model.DependencyRequest;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class InjectionMethods {
    InjectionMethods() {
    }

    private static MethodSpec methodProxy(ExecutableElement method, String methodName, InstanceCastPolicy instanceCastPolicy, CheckNotNullPolicy checkNotNullPolicy, KotlinMetadataUtil metadataUtil) {
        CodeBlock instance;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).varargs(method.isVarArgs());
        TypeElement enclosingType = MoreElements.asType(method.getEnclosingElement());
        boolean isMethodInKotlinObject = metadataUtil.isObjectClass(enclosingType);
        boolean isMethodInKotlinCompanionObject = metadataUtil.isCompanionObjectClass(enclosingType);
        UniqueNameSet parameterNameSet = new UniqueNameSet();
        if (isMethodInKotlinCompanionObject || method.getModifiers().contains((Object)Modifier.STATIC)) {
            instance = CodeBlock.of((String)"$T", (Object[])new Object[]{TypeNames.rawTypeName(TypeName.get((TypeMirror)enclosingType.asType()))});
        } else if (isMethodInKotlinObject) {
            instance = CodeBlock.of((String)"$T.INSTANCE", (Object[])new Object[]{TypeNames.rawTypeName(TypeName.get((TypeMirror)enclosingType.asType()))});
        } else {
            InjectionMethods.copyTypeParameters(builder, enclosingType);
            boolean useObject = instanceCastPolicy.useObjectType(enclosingType.asType());
            instance = InjectionMethods.copyInstance(builder, parameterNameSet, enclosingType.asType(), useObject);
        }
        CodeBlock arguments = InjectionMethods.copyParameters(builder, parameterNameSet, method.getParameters());
        CodeBlock invocation = checkNotNullPolicy.checkForNull(CodeBlock.of((String)"$L.$L($L)", (Object[])new Object[]{instance, method.getSimpleName(), arguments}));
        InjectionMethods.copyTypeParameters(builder, method);
        InjectionMethods.copyThrows(builder, method);
        if (method.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
            return builder.addStatement("$L", new Object[]{invocation}).build();
        }
        ConfigurationAnnotations.getNullableType(method).ifPresent(annotation -> CodeBlocks.addAnnotation(builder, annotation));
        return builder.returns(TypeName.get((TypeMirror)method.getReturnType())).addStatement("return $L", new Object[]{invocation}).build();
    }

    private static MethodSpec fieldProxy(VariableElement field, String methodName, Optional<AnnotationMirror> qualifierAnnotation) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(AnnotationSpec.builder((ClassName)TypeNames.INJECTED_FIELD_SIGNATURE).addMember("value", "$S", new Object[]{SourceFiles.memberInjectedFieldSignatureForVariable(field)}).build());
        qualifierAnnotation.map(AnnotationSpec::get).ifPresent(arg_0 -> ((MethodSpec.Builder)builder).addAnnotation(arg_0));
        TypeElement enclosingType = MoreElements.asType(field.getEnclosingElement());
        InjectionMethods.copyTypeParameters(builder, enclosingType);
        boolean useObject = !Accessibility.isRawTypePubliclyAccessible(enclosingType.asType());
        UniqueNameSet parameterNameSet = new UniqueNameSet();
        CodeBlock instance = InjectionMethods.copyInstance(builder, parameterNameSet, enclosingType.asType(), useObject);
        CodeBlock argument = InjectionMethods.copyParameters(builder, parameterNameSet, (List<? extends VariableElement>)ImmutableList.of((Object)field));
        return builder.addStatement("$L.$L = $L", new Object[]{instance, field.getSimpleName(), argument}).build();
    }

    private static CodeBlock invokeMethod(MethodSpec methodSpec, ImmutableList<CodeBlock> parameters2, ClassName enclosingClass, ClassName requestingClass) {
        com.google.common.base.Preconditions.checkArgument((methodSpec.parameters.size() == parameters2.size() ? 1 : 0) != 0);
        CodeBlock parameterBlock = CodeBlocks.makeParametersCodeBlock(parameters2);
        return enclosingClass.equals((Object)requestingClass) ? CodeBlock.of((String)"$L($L)", (Object[])new Object[]{methodSpec.name, parameterBlock}) : CodeBlock.of((String)"$T.$L($L)", (Object[])new Object[]{enclosingClass, methodSpec.name, parameterBlock});
    }

    private static void copyTypeParameters(MethodSpec.Builder methodBuilder, Parameterizable element) {
        element.getTypeParameters().stream().map(TypeVariableName::get).forEach(arg_0 -> ((MethodSpec.Builder)methodBuilder).addTypeVariable(arg_0));
    }

    private static void copyThrows(MethodSpec.Builder methodBuilder, ExecutableElement method) {
        method.getThrownTypes().stream().map(TypeName::get).forEach(arg_0 -> ((MethodSpec.Builder)methodBuilder).addException(arg_0));
    }

    private static CodeBlock copyParameters(MethodSpec.Builder methodBuilder, UniqueNameSet parameterNameSet, List<? extends VariableElement> parameters2) {
        return parameters2.stream().map(parameter -> {
            String name2 = parameterNameSet.getUniqueName(InjectionMethods.validJavaName(parameter.getSimpleName()));
            TypeMirror type2 = parameter.asType();
            boolean useObject = !Accessibility.isRawTypePubliclyAccessible(type2);
            return InjectionMethods.copyParameter(methodBuilder, type2, name2, useObject);
        }).collect(CodeBlocks.toParametersCodeBlock());
    }

    private static CodeBlock copyParameter(MethodSpec.Builder methodBuilder, TypeMirror type2, String name2, boolean useObject) {
        ClassName typeName2 = useObject ? TypeName.OBJECT : TypeName.get((TypeMirror)type2);
        methodBuilder.addParameter(ParameterSpec.builder((TypeName)typeName2, (String)name2, (Modifier[])new Modifier[0]).build());
        return useObject ? CodeBlock.of((String)"($T) $L", (Object[])new Object[]{type2, name2}) : CodeBlock.of((String)"$L", (Object[])new Object[]{name2});
    }

    private static CodeBlock copyInstance(MethodSpec.Builder methodBuilder, UniqueNameSet parameterNameSet, TypeMirror type2, boolean useObject) {
        CodeBlock instance = InjectionMethods.copyParameter(methodBuilder, type2, parameterNameSet.getUniqueName("instance"), useObject);
        return useObject ? CodeBlock.of((String)"($L)", (Object[])new Object[]{instance}) : instance;
    }

    private static String validJavaName(CharSequence name2) {
        if (SourceVersion.isIdentifier(name2)) {
            return SourceFiles.protectAgainstKeywords(name2.toString());
        }
        StringBuilder newName = new StringBuilder(name2.length());
        char firstChar = name2.charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar)) {
            newName.append('_');
        }
        name2.chars().forEach(c -> newName.append(Character.isJavaIdentifierPart(c) ? c : 95));
        return newName.toString();
    }

    private static enum CheckNotNullPolicy {
        IGNORE,
        CHECK_FOR_NULL;


        CodeBlock checkForNull(CodeBlock maybeNull) {
            return this.equals((Object)IGNORE) ? maybeNull : CodeBlock.of((String)"$T.checkNotNullFromProvides($L)", (Object[])new Object[]{Preconditions.class, maybeNull});
        }

        static CheckNotNullPolicy get(ProvisionBinding binding, CompilerOptions compilerOptions) {
            return binding.shouldCheckForNull(compilerOptions) ? CHECK_FOR_NULL : IGNORE;
        }
    }

    private static enum InstanceCastPolicy {
        CAST_IF_NOT_PUBLIC,
        IGNORE;


        boolean useObjectType(TypeMirror instanceType) {
            return this == CAST_IF_NOT_PUBLIC && !Accessibility.isRawTypePubliclyAccessible(instanceType);
        }
    }

    static final class InjectionSiteMethod {
        InjectionSiteMethod() {
        }

        static MethodSpec create(MembersInjectionBinding.InjectionSite injectionSite, KotlinMetadataUtil metadataUtil) {
            String methodName = InjectionSiteMethod.methodName(injectionSite);
            switch (injectionSite.kind()) {
                case METHOD: {
                    return InjectionMethods.methodProxy(MoreElements.asExecutable(injectionSite.element()), methodName, InstanceCastPolicy.CAST_IF_NOT_PUBLIC, CheckNotNullPolicy.IGNORE, metadataUtil);
                }
                case FIELD: {
                    Optional<AnnotationMirror> qualifier = ((DependencyRequest)injectionSite.dependencies().stream().collect(DaggerCollectors.onlyElement())).key().qualifier().map(DaggerAnnotation::java);
                    return InjectionMethods.fieldProxy(MoreElements.asVariable(injectionSite.element()), methodName, qualifier);
                }
            }
            throw new AssertionError(injectionSite);
        }

        static CodeBlock invokeAll(ImmutableSet<MembersInjectionBinding.InjectionSite> injectionSites, ClassName generatedTypeName, CodeBlock instanceCodeBlock, TypeMirror instanceType, Function<DependencyRequest, CodeBlock> dependencyUsage, DaggerTypes types, KotlinMetadataUtil metadataUtil) {
            return injectionSites.stream().map(injectionSite -> {
                TypeMirror injectSiteType = types.erasure(injectionSite.element().getEnclosingElement().asType());
                CodeBlock maybeCastedInstance = !types.isSubtype(instanceType, injectSiteType) && Accessibility.isTypeAccessibleFrom(injectSiteType, generatedTypeName.packageName()) ? CodeBlock.of((String)"($T) $L", (Object[])new Object[]{injectSiteType, instanceCodeBlock}) : instanceCodeBlock;
                return CodeBlock.of((String)"$L;", (Object[])new Object[]{InjectionSiteMethod.invoke(injectionSite, generatedTypeName, maybeCastedInstance, dependencyUsage, metadataUtil)});
            }).collect(CodeBlocks.toConcatenatedCodeBlock());
        }

        private static CodeBlock invoke(MembersInjectionBinding.InjectionSite injectionSite, ClassName generatedTypeName, CodeBlock instanceCodeBlock, Function<DependencyRequest, CodeBlock> dependencyUsage, KotlinMetadataUtil metadataUtil) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add((Object)instanceCodeBlock);
            if (!injectionSite.dependencies().isEmpty()) {
                arguments.addAll((Iterable)injectionSite.dependencies().stream().map(dependencyUsage).collect(Collectors.toList()));
            }
            ClassName enclosingClass = SourceFiles.membersInjectorNameForType(MoreElements.asType(injectionSite.element().getEnclosingElement()));
            MethodSpec methodSpec = InjectionSiteMethod.create(injectionSite, metadataUtil);
            return InjectionMethods.invokeMethod(methodSpec, (ImmutableList<CodeBlock>)arguments.build(), enclosingClass, generatedTypeName);
        }

        private static String methodName(MembersInjectionBinding.InjectionSite injectionSite) {
            int index = injectionSite.indexAmongAtInjectMembersWithSameSimpleName();
            String indexString = index == 0 ? "" : String.valueOf(index + 1);
            return "inject" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, injectionSite.element().getSimpleName().toString()) + indexString;
        }
    }

    static final class ProvisionMethod {
        private static final ImmutableSet<String> BANNED_PROXY_NAMES = ImmutableSet.of((Object)"get", (Object)"create");

        ProvisionMethod() {
        }

        static MethodSpec create(ProvisionBinding binding, CompilerOptions compilerOptions, KotlinMetadataUtil metadataUtil) {
            ExecutableElement element = MoreElements.asExecutable(binding.bindingElement().get());
            switch (element.getKind()) {
                case CONSTRUCTOR: {
                    return ProvisionMethod.constructorProxy(element);
                }
                case METHOD: {
                    return InjectionMethods.methodProxy(element, ProvisionMethod.methodName(element), InstanceCastPolicy.IGNORE, CheckNotNullPolicy.get(binding, compilerOptions), metadataUtil);
                }
            }
            throw new AssertionError(element);
        }

        static CodeBlock invoke(ProvisionBinding binding, Function<DependencyRequest, CodeBlock> dependencyUsage, Function<VariableElement, String> uniqueAssistedParameterName, ClassName requestingClass, Optional<CodeBlock> moduleReference, CompilerOptions compilerOptions, KotlinMetadataUtil metadataUtil) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            moduleReference.ifPresent(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
            ProvisionMethod.invokeArguments(binding, dependencyUsage, uniqueAssistedParameterName).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
            ClassName enclosingClass = SourceFiles.generatedClassNameForBinding(binding);
            MethodSpec methodSpec = ProvisionMethod.create(binding, compilerOptions, metadataUtil);
            return InjectionMethods.invokeMethod(methodSpec, (ImmutableList<CodeBlock>)arguments.build(), enclosingClass, requestingClass);
        }

        static ImmutableList<CodeBlock> invokeArguments(ProvisionBinding binding, Function<DependencyRequest, CodeBlock> dependencyUsage, Function<VariableElement, String> uniqueAssistedParameterName) {
            ImmutableMap dependencyRequestMap = (ImmutableMap)binding.provisionDependencies().stream().collect(DaggerStreams.toImmutableMap(request -> MoreElements.asVariable(((DaggerElement)request.requestElement().get()).java()), request -> request));
            ImmutableList.Builder arguments = ImmutableList.builder();
            ExecutableElement method = MoreElements.asExecutable(binding.bindingElement().get());
            for (VariableElement variableElement : method.getParameters()) {
                if (AssistedInjectionAnnotations.isAssistedParameter(variableElement)) {
                    arguments.add((Object)CodeBlock.of((String)"$L", (Object[])new Object[]{uniqueAssistedParameterName.apply(variableElement)}));
                    continue;
                }
                if (dependencyRequestMap.containsKey((Object)variableElement)) {
                    DependencyRequest request2 = (DependencyRequest)dependencyRequestMap.get((Object)variableElement);
                    arguments.add((Object)dependencyUsage.apply(request2));
                    continue;
                }
                throw new AssertionError((Object)("Unexpected parameter: " + variableElement));
            }
            return arguments.build();
        }

        private static MethodSpec constructorProxy(ExecutableElement constructor) {
            TypeElement enclosingType = MoreElements.asType(constructor.getEnclosingElement());
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)ProvisionMethod.methodName(constructor)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).varargs(constructor.isVarArgs()).returns(TypeName.get((TypeMirror)enclosingType.asType()));
            InjectionMethods.copyTypeParameters(builder, enclosingType);
            InjectionMethods.copyThrows(builder, constructor);
            CodeBlock arguments = InjectionMethods.copyParameters(builder, new UniqueNameSet(), constructor.getParameters());
            return builder.addStatement("return new $T($L)", new Object[]{enclosingType, arguments}).build();
        }

        static boolean requiresInjectionMethod(ProvisionBinding binding, CompilerOptions compilerOptions, ClassName requestingClass) {
            ExecutableElement method = MoreElements.asExecutable(binding.bindingElement().get());
            return !binding.injectionSites().isEmpty() || binding.shouldCheckForNull(compilerOptions) || !Accessibility.isElementAccessibleFrom(method, requestingClass.packageName()) || method.getParameters().stream().map(Element::asType).anyMatch(type2 -> !Accessibility.isRawTypeAccessible(type2, requestingClass.packageName()));
        }

        private static String methodName(ExecutableElement method) {
            switch (method.getKind()) {
                case CONSTRUCTOR: {
                    return "newInstance";
                }
                case METHOD: {
                    String methodName = method.getSimpleName().toString();
                    return BANNED_PROXY_NAMES.contains((Object)methodName) ? "proxy" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, methodName) : methodName;
                }
            }
            throw new AssertionError(method);
        }
    }
}

