/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Equivalence;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.shaded.auto.common.MoreTypes;
import dagger.shaded.auto.common.SuperficialValidation;
import java.util.ArrayDeque;
import java.util.HashSet;
import javax.lang.model.type.TypeMirror;

final class TypeHierarchyValidator {
    private TypeHierarchyValidator() {
    }

    public static void validateTypeHierarchy(TypeMirror type2, DaggerTypes types) {
        ArrayDeque<TypeMirror> queue = new ArrayDeque<TypeMirror>();
        HashSet<Equivalence.Wrapper> queued = new HashSet<Equivalence.Wrapper>();
        queue.add(type2);
        queued.add(MoreTypes.equivalence().wrap((Object)type2));
        while (!queue.isEmpty()) {
            TypeMirror currType = (TypeMirror)queue.remove();
            if (!SuperficialValidation.validateType(currType)) {
                throw new TypeNotPresentException(currType.toString(), null);
            }
            for (TypeMirror typeMirror : types.directSupertypes(currType)) {
                if (!queued.add(MoreTypes.equivalence().wrap((Object)typeMirror))) continue;
                queue.add(typeMirror);
            }
        }
    }
}

