/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.Scopes;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.Scope;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

@Singleton
public final class InjectValidator
implements ClearableCache {
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final CompilerOptions compilerOptions;
    private final DependencyRequestValidator dependencyRequestValidator;
    private final Optional<Diagnostic.Kind> privateAndStaticInjectionDiagnosticKind;
    private final InjectionAnnotations injectionAnnotations;
    private final KotlinMetadataUtil metadataUtil;
    private final Map<ExecutableElement, ValidationReport> reports = new HashMap<ExecutableElement, ValidationReport>();

    @Inject
    InjectValidator(DaggerTypes types, DaggerElements elements, DependencyRequestValidator dependencyRequestValidator, CompilerOptions compilerOptions, InjectionAnnotations injectionAnnotations, KotlinMetadataUtil metadataUtil) {
        this(types, elements, compilerOptions, dependencyRequestValidator, Optional.empty(), injectionAnnotations, metadataUtil);
    }

    private InjectValidator(DaggerTypes types, DaggerElements elements, CompilerOptions compilerOptions, DependencyRequestValidator dependencyRequestValidator, Optional<Diagnostic.Kind> privateAndStaticInjectionDiagnosticKind, InjectionAnnotations injectionAnnotations, KotlinMetadataUtil metadataUtil) {
        this.types = types;
        this.elements = elements;
        this.compilerOptions = compilerOptions;
        this.dependencyRequestValidator = dependencyRequestValidator;
        this.privateAndStaticInjectionDiagnosticKind = privateAndStaticInjectionDiagnosticKind;
        this.injectionAnnotations = injectionAnnotations;
        this.metadataUtil = metadataUtil;
    }

    @Override
    public void clearCache() {
        this.reports.clear();
    }

    public InjectValidator whenGeneratingCode() {
        return this.compilerOptions.ignorePrivateAndStaticInjectionForComponent() ? this : new InjectValidator(this.types, this.elements, this.compilerOptions, this.dependencyRequestValidator, Optional.of(Diagnostic.Kind.ERROR), this.injectionAnnotations, this.metadataUtil);
    }

    public ValidationReport validateConstructor(ExecutableElement constructorElement) {
        return Util.reentrantComputeIfAbsent(this.reports, constructorElement, this::validateConstructorUncached);
    }

    private ValidationReport validateConstructorUncached(ExecutableElement constructorElement) {
        ValidationReport.Builder builder;
        block13: {
            ImmutableSet<Scope> scopes;
            TypeElement enclosingElement2;
            block12: {
                ImmutableSet injectConstructors;
                Class injectAnnotation;
                builder = ValidationReport.about(MoreElements.asType(constructorElement.getEnclosingElement()));
                if (MoreElements.isAnnotationPresent(constructorElement, Inject.class) && MoreElements.isAnnotationPresent(constructorElement, AssistedInject.class)) {
                    builder.addError("Constructors cannot be annotated with both @Inject and @AssistedInject");
                }
                Class clazz = injectAnnotation = MoreElements.isAnnotationPresent(constructorElement, Inject.class) ? Inject.class : AssistedInject.class;
                if (constructorElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    builder.addError("Dagger does not support injection into private constructors", constructorElement);
                }
                for (Object qualifier : this.injectionAnnotations.getQualifiers(constructorElement)) {
                    builder.addError(String.format("@Qualifier annotations are not allowed on @%s constructors", injectAnnotation.getSimpleName()), constructorElement, (AnnotationMirror)qualifier);
                }
                String scopeErrorMsg = String.format("@Scope annotations are not allowed on @%s constructors", injectAnnotation.getSimpleName());
                if (injectAnnotation == Inject.class) {
                    scopeErrorMsg = scopeErrorMsg + "; annotate the class instead";
                }
                for (Scope scope : Scopes.scopesOf(constructorElement)) {
                    builder.addError(scopeErrorMsg, constructorElement, scope.scopeAnnotation().java());
                }
                for (VariableElement parameter : constructorElement.getParameters()) {
                    this.validateDependencyRequest(builder, parameter);
                }
                if (this.throwsCheckedExceptions(constructorElement)) {
                    builder.addItem(String.format("Dagger does not support checked exceptions on @%s constructors", injectAnnotation.getSimpleName()), this.privateMemberDiagnosticKind(), constructorElement);
                }
                this.checkInjectIntoPrivateClass(constructorElement, builder);
                enclosingElement2 = MoreElements.asType(constructorElement.getEnclosingElement());
                Set<Modifier> typeModifiers = enclosingElement2.getModifiers();
                if (typeModifiers.contains((Object)Modifier.ABSTRACT)) {
                    builder.addError(String.format("@%s is nonsense on the constructor of an abstract class", injectAnnotation.getSimpleName()), constructorElement);
                }
                if (enclosingElement2.getNestingKind().isNested() && !typeModifiers.contains((Object)Modifier.STATIC)) {
                    builder.addError(String.format("@%s constructors are invalid on inner classes. Did you mean to make the class static?", injectAnnotation.getSimpleName()), constructorElement);
                }
                if ((injectConstructors = ImmutableSet.builder().addAll(InjectionAnnotations.injectedConstructors(enclosingElement2)).addAll(AssistedInjectionAnnotations.assistedInjectedConstructors(enclosingElement2)).build()).size() > 1) {
                    builder.addError("Types may only contain one injected constructor", constructorElement);
                }
                scopes = Scopes.scopesOf(enclosingElement2);
                if (injectAnnotation != AssistedInject.class) break block12;
                for (Scope scope : scopes) {
                    builder.addError("A type with an @AssistedInject-annotated constructor cannot be scoped", enclosingElement2, scope.scopeAnnotation().java());
                }
                break block13;
            }
            if (scopes.size() <= 1) break block13;
            for (Scope scope : scopes) {
                builder.addError("A single binding may not declare more than one @Scope", enclosingElement2, scope.scopeAnnotation().java());
            }
        }
        return builder.build();
    }

    private ValidationReport validateField(VariableElement fieldElement) {
        ValidationReport.Builder builder = ValidationReport.about(fieldElement);
        Set<Modifier> modifiers = fieldElement.getModifiers();
        if (modifiers.contains((Object)Modifier.FINAL)) {
            builder.addError("@Inject fields may not be final", fieldElement);
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            builder.addItem("Dagger does not support injection into private fields", this.privateMemberDiagnosticKind(), fieldElement);
        }
        if (modifiers.contains((Object)Modifier.STATIC)) {
            builder.addItem("Dagger does not support injection into static fields", this.staticMemberDiagnosticKind(), fieldElement);
        }
        this.validateDependencyRequest(builder, fieldElement);
        return builder.build();
    }

    private ValidationReport validateMethod(ExecutableElement methodElement) {
        ValidationReport.Builder builder = ValidationReport.about(methodElement);
        Set<Modifier> modifiers = methodElement.getModifiers();
        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
            builder.addError("Methods with @Inject may not be abstract", methodElement);
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            builder.addItem("Dagger does not support injection into private methods", this.privateMemberDiagnosticKind(), methodElement);
        }
        if (modifiers.contains((Object)Modifier.STATIC)) {
            builder.addItem("Dagger does not support injection into static methods", this.staticMemberDiagnosticKind(), methodElement);
        }
        if (!methodElement.getTypeParameters().isEmpty()) {
            builder.addError("Methods with @Inject may not declare type parameters", methodElement);
        }
        if (!methodElement.getThrownTypes().isEmpty()) {
            builder.addError("Methods with @Inject may not throw checked exceptions. Please wrap your exceptions in a RuntimeException instead.", methodElement);
        }
        for (VariableElement variableElement : methodElement.getParameters()) {
            this.validateDependencyRequest(builder, variableElement);
        }
        return builder.build();
    }

    private void validateDependencyRequest(ValidationReport.Builder builder, VariableElement parameter) {
        this.dependencyRequestValidator.validateDependencyRequest(builder, parameter, parameter.asType());
        this.dependencyRequestValidator.checkNotProducer(builder, parameter);
    }

    public ValidationReport validateMembersInjectionType(TypeElement typeElement2) {
        ValidationReport validationReport;
        TypeMirror superclass;
        ValidationReport.Builder builder = ValidationReport.about(typeElement2);
        boolean hasInjectedMembers = false;
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement2.getEnclosedElements())) {
            if (!MoreElements.isAnnotationPresent(variableElement, Inject.class)) continue;
            hasInjectedMembers = true;
            ValidationReport report2 = this.validateField(variableElement);
            if (report2.isClean()) continue;
            builder.addSubreport(report2);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement2.getEnclosedElements())) {
            if (!MoreElements.isAnnotationPresent(executableElement, Inject.class)) continue;
            hasInjectedMembers = true;
            ValidationReport report = this.validateMethod(executableElement);
            if (report.isClean()) continue;
            builder.addSubreport(report);
        }
        if (hasInjectedMembers) {
            this.checkInjectIntoPrivateClass(typeElement2, builder);
            this.checkInjectIntoKotlinObject(typeElement2, builder);
        }
        if (!(superclass = typeElement2.getSuperclass()).getKind().equals((Object)TypeKind.NONE) && !(validationReport = this.validateType(MoreTypes.asTypeElement(superclass))).isClean()) {
            builder.addSubreport(validationReport);
        }
        return builder.build();
    }

    public ValidationReport validateType(TypeElement typeElement2) {
        ValidationReport.Builder builder = ValidationReport.about(typeElement2);
        ValidationReport membersInjectionReport = this.validateMembersInjectionType(typeElement2);
        if (!membersInjectionReport.isClean()) {
            builder.addSubreport(membersInjectionReport);
        }
        for (ExecutableElement element : ElementFilter.constructorsIn(typeElement2.getEnclosedElements())) {
            ValidationReport report;
            if (!MoreElements.isAnnotationPresent(element, Inject.class) && !MoreElements.isAnnotationPresent(element, AssistedInject.class) || (report = this.validateConstructor(element)).isClean()) continue;
            builder.addSubreport(report);
        }
        return builder.build();
    }

    public boolean isValidType(TypeMirror type2) {
        if (!type2.getKind().equals((Object)TypeKind.DECLARED)) {
            return true;
        }
        return this.validateType(MoreTypes.asTypeElement(type2)).isClean();
    }

    private boolean throwsCheckedExceptions(ExecutableElement methodElement) {
        TypeMirror runtimeExceptionType = this.elements.getTypeElement(RuntimeException.class).asType();
        TypeMirror errorType = this.elements.getTypeElement(Error.class).asType();
        for (TypeMirror typeMirror : methodElement.getThrownTypes()) {
            if (this.types.isSubtype(typeMirror, runtimeExceptionType) || this.types.isSubtype(typeMirror, errorType)) continue;
            return true;
        }
        return false;
    }

    private void checkInjectIntoPrivateClass(Element element, ValidationReport.Builder builder) {
        if (!Accessibility.isElementAccessibleFromOwnPackage(DaggerElements.closestEnclosingTypeElement(element))) {
            builder.addItem("Dagger does not support injection into private classes", this.privateMemberDiagnosticKind(), element);
        }
    }

    private void checkInjectIntoKotlinObject(TypeElement element, ValidationReport.Builder builder) {
        if (this.metadataUtil.isObjectClass(element) || this.metadataUtil.isCompanionObjectClass(element)) {
            builder.addError("Dagger does not support injection into Kotlin objects", element);
        }
    }

    private Diagnostic.Kind privateMemberDiagnosticKind() {
        return this.privateAndStaticInjectionDiagnosticKind.orElse(this.compilerOptions.privateMemberValidationKind());
    }

    private Diagnostic.Kind staticMemberDiagnosticKind() {
        return this.privateAndStaticInjectionDiagnosticKind.orElse(this.compilerOptions.staticMemberValidationKind());
    }
}

