/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.base.MoreAnnotationMirrors;
import dagger.internal.codegen.binding.ComponentCreatorAnnotation;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public final class ConfigurationAnnotations {
    public static Optional<TypeElement> getSubcomponentCreator(TypeElement subcomponent) {
        Preconditions.checkArgument((boolean)ComponentAnnotation.subcomponentAnnotation(subcomponent).isPresent());
        for (TypeElement nestedType : ElementFilter.typesIn(subcomponent.getEnclosedElements())) {
            if (!ConfigurationAnnotations.isSubcomponentCreator(nestedType)) continue;
            return Optional.of(nestedType);
        }
        return Optional.empty();
    }

    static boolean isSubcomponentCreator(Element element) {
        return DaggerElements.isAnyAnnotationPresent(element, ComponentCreatorAnnotation.subcomponentCreatorAnnotations());
    }

    public static ImmutableList<TypeMirror> getModuleInjects(AnnotationMirror moduleAnnotation) {
        Preconditions.checkNotNull((Object)moduleAnnotation);
        return MoreAnnotationMirrors.getTypeListValue(moduleAnnotation, "injects");
    }

    public static Optional<DeclaredType> getNullableType(Element element) {
        List<? extends AnnotationMirror> mirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            if (!annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals("Nullable")) continue;
            return Optional.of(annotationMirror.getAnnotationType());
        }
        return Optional.empty();
    }

    @Deprecated
    public static ImmutableSet<TypeElement> getTransitiveModules(DaggerTypes types, DaggerElements elements, Iterable<TypeElement> seedModules) {
        TypeMirror objectType = elements.getTypeElement(Object.class).asType();
        ArrayDeque moduleQueue = new ArrayDeque();
        Iterables.addAll(moduleQueue, seedModules);
        LinkedHashSet moduleElements = Sets.newLinkedHashSet();
        for (TypeElement moduleElement : Iterables.consumingIterable(moduleQueue)) {
            ModuleAnnotation.moduleAnnotation(moduleElement).ifPresent(moduleAnnotation -> {
                ImmutableSet.Builder moduleDependenciesBuilder = ImmutableSet.builder();
                moduleDependenciesBuilder.addAll(moduleAnnotation.includes());
                ConfigurationAnnotations.addIncludesFromSuperclasses(types, moduleElement, (ImmutableSet.Builder<TypeElement>)moduleDependenciesBuilder, objectType);
                ImmutableSet moduleDependencies = moduleDependenciesBuilder.build();
                moduleElements.add(moduleElement);
                for (TypeElement dependencyType : moduleDependencies) {
                    if (moduleElements.contains(dependencyType)) continue;
                    moduleQueue.add(dependencyType);
                }
            });
        }
        return ImmutableSet.copyOf((Collection)moduleElements);
    }

    public static ImmutableList<DeclaredType> enclosedAnnotatedTypes(TypeElement typeElement2, ClassName annotation) {
        ImmutableList.Builder builders = ImmutableList.builder();
        for (TypeElement element : ElementFilter.typesIn(typeElement2.getEnclosedElements())) {
            if (!DaggerElements.isAnnotationPresent((Element)element, annotation)) continue;
            builders.add((Object)MoreTypes.asDeclared(element.asType()));
        }
        return builders.build();
    }

    private static void addIncludesFromSuperclasses(DaggerTypes types, TypeElement element, ImmutableSet.Builder<TypeElement> builder, TypeMirror objectType) {
        TypeMirror superclass = element.getSuperclass();
        while (!types.isSameType(objectType, superclass) && superclass.getKind().equals((Object)TypeKind.DECLARED)) {
            element = MoreElements.asType(types.asElement(superclass));
            ModuleAnnotation.moduleAnnotation(element).ifPresent(moduleAnnotation -> builder.addAll(moduleAnnotation.includes()));
            superclass = element.getSuperclass();
        }
    }

    private ConfigurationAnnotations() {
    }
}

