/*
 * Decompiled with CFR 0.152.
 */
package dagger.shaded.androidx.room.compiler.processing.javac;

import dagger.shaded.androidx.room.compiler.processing.javac.JavacExecutableElement;
import dagger.shaded.androidx.room.compiler.processing.javac.JavacMethodElement;
import dagger.shaded.androidx.room.compiler.processing.javac.JavacProcessingEnv;
import dagger.shaded.androidx.room.compiler.processing.javac.JavacTypeElement;
import dagger.shaded.androidx.room.compiler.processing.javac.JavacVariableElement;
import dagger.shaded.androidx.room.compiler.processing.javac.kotlin.KmType;
import dagger.shaded.androidx.room.compiler.processing.javac.kotlin.KmValueParameter;
import dagger.shaded.androidx.room.compiler.processing.util.NamingUtilsKt;
import javax.lang.model.element.VariableElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014\u00a8\u0006\u001d"}, d2={"Ldagger/shaded/androidx/room/compiler/processing/javac/JavacMethodParameter;", "Ldagger/shaded/androidx/room/compiler/processing/javac/JavacVariableElement;", "env", "Ldagger/shaded/androidx/room/compiler/processing/javac/JavacProcessingEnv;", "executable", "Ldagger/shaded/androidx/room/compiler/processing/javac/JavacExecutableElement;", "containing", "Ldagger/shaded/androidx/room/compiler/processing/javac/JavacTypeElement;", "element", "Ljavax/lang/model/element/VariableElement;", "kotlinMetadata", "Ldagger/shaded/androidx/room/compiler/processing/javac/kotlin/KmValueParameter;", "argIndex", "", "(Landroidx/room/compiler/processing/javac/JavacProcessingEnv;Landroidx/room/compiler/processing/javac/JavacExecutableElement;Landroidx/room/compiler/processing/javac/JavacTypeElement;Ljavax/lang/model/element/VariableElement;Landroidx/room/compiler/processing/javac/kotlin/KmValueParameter;I)V", "getArgIndex", "()I", "fallbackLocationText", "", "getFallbackLocationText", "()Ljava/lang/String;", "getKotlinMetadata", "()Landroidx/room/compiler/processing/javac/kotlin/KmValueParameter;", "kotlinType", "Ldagger/shaded/androidx/room/compiler/processing/javac/kotlin/KmType;", "getKotlinType", "()Landroidx/room/compiler/processing/javac/kotlin/KmType;", "name", "getName", "room-compiler-processing"})
public final class JavacMethodParameter
extends JavacVariableElement {
    @NotNull
    private final JavacExecutableElement executable;
    @Nullable
    private final KmValueParameter kotlinMetadata;
    private final int argIndex;

    public JavacMethodParameter(@NotNull JavacProcessingEnv env, @NotNull JavacExecutableElement executable, @NotNull JavacTypeElement containing, @NotNull VariableElement element, @Nullable KmValueParameter kotlinMetadata2, int argIndex) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(env, containing, element);
        this.executable = executable;
        this.kotlinMetadata = kotlinMetadata2;
        this.argIndex = argIndex;
    }

    @Nullable
    public final KmValueParameter getKotlinMetadata() {
        return this.kotlinMetadata;
    }

    public final int getArgIndex() {
        return this.argIndex;
    }

    @Override
    @NotNull
    public String getName() {
        KmValueParameter kmValueParameter = this.kotlinMetadata;
        String string = kmValueParameter == null ? null : kmValueParameter.getName();
        return NamingUtilsKt.sanitizeAsJavaParameterName(string == null ? super.getName() : string, this.argIndex);
    }

    @Override
    @Nullable
    public KmType getKotlinType() {
        KmValueParameter kmValueParameter = this.kotlinMetadata;
        return kmValueParameter == null ? null : kmValueParameter.getType();
    }

    @Override
    @NotNull
    public String getFallbackLocationText() {
        return this.executable instanceof JavacMethodElement && ((JavacMethodElement)this.executable).isSuspendFunction() && this == CollectionsKt.last(this.executable.getParameters()) ? Intrinsics.stringPlus((String)"return type of ", (Object)this.executable.getFallbackLocationText()) : this.getName() + " in " + this.executable.getFallbackLocationText();
    }
}

