/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.BindingExpression;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.MethodBindingExpression;
import dagger.spi.model.RequestKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class PrivateMethodBindingExpression
extends MethodBindingExpression {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final ContributionBinding binding;
    private final BindingRequest request;
    private final BindingExpression wrappedBindingExpression;
    private final CompilerOptions compilerOptions;
    private final DaggerTypes types;
    private String methodName;

    @AssistedInject
    PrivateMethodBindingExpression(@Assisted BindingRequest request, @Assisted ContributionBinding binding, @Assisted BindingExpression wrappedBindingExpression, ComponentImplementation componentImplementation, DaggerTypes types, CompilerOptions compilerOptions) {
        super(componentImplementation.shardImplementation(binding), types);
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.request = (BindingRequest)Preconditions.checkNotNull((Object)request);
        this.wrappedBindingExpression = (BindingExpression)Preconditions.checkNotNull((Object)wrappedBindingExpression);
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.compilerOptions = compilerOptions;
        this.types = types;
    }

    @Override
    protected CodeBlock methodCall() {
        return CodeBlock.of((String)"$N()", (Object[])new Object[]{this.methodName()});
    }

    @Override
    protected TypeMirror returnType() {
        if (this.request.isRequestKind(RequestKind.INSTANCE) && this.binding.contributedPrimitiveType().isPresent()) {
            return this.binding.contributedPrimitiveType().get();
        }
        TypeMirror requestedType = this.request.requestedType(this.binding.contributedType(), this.types);
        return this.types.accessibleType(requestedType, this.shardImplementation.name());
    }

    private String methodName() {
        if (this.methodName == null) {
            this.methodName = this.shardImplementation.getUniqueMethodName(this.request);
            this.shardImplementation.addMethod(ComponentImplementation.MethodSpecKind.PRIVATE_METHOD, MethodSpec.methodBuilder((String)this.methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(TypeName.get((TypeMirror)this.returnType())).addStatement("return $L", new Object[]{this.wrappedBindingExpression.getDependencyExpression(this.shardImplementation.name()).codeBlock()}).build());
        }
        return this.methodName;
    }

    @AssistedFactory
    static interface Factory {
        public PrivateMethodBindingExpression create(BindingRequest var1, ContributionBinding var2, BindingExpression var3);
    }
}

