/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.CodeBlock;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.BindingExpression;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.MethodBindingExpression;
import javax.lang.model.type.TypeMirror;

final class ComponentMethodBindingExpression
extends MethodBindingExpression {
    private final BindingExpression wrappedBindingExpression;
    private final ComponentImplementation componentImplementation;
    private final ComponentDescriptor.ComponentMethodDescriptor componentMethod;
    private final DaggerTypes types;

    @AssistedInject
    ComponentMethodBindingExpression(@Assisted BindingExpression wrappedBindingExpression, @Assisted ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation componentImplementation, DaggerTypes types) {
        super(componentImplementation.getComponentShard(), types);
        this.wrappedBindingExpression = (BindingExpression)Preconditions.checkNotNull((Object)wrappedBindingExpression);
        this.componentMethod = (ComponentDescriptor.ComponentMethodDescriptor)Preconditions.checkNotNull((Object)componentMethod);
        this.componentImplementation = componentImplementation;
        this.types = types;
    }

    @Override
    protected CodeBlock getComponentMethodImplementation(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation component) {
        return componentMethod.equals(this.componentMethod) && component.equals(this.componentImplementation) ? CodeBlock.of((String)"return $L;", (Object[])new Object[]{this.wrappedBindingExpression.getDependencyExpressionForComponentMethod(componentMethod, this.componentImplementation).codeBlock()}) : super.getComponentMethodImplementation(componentMethod, component);
    }

    @Override
    protected CodeBlock methodCall() {
        return CodeBlock.of((String)"$N()", (Object[])new Object[]{this.componentMethod.methodElement().getSimpleName()});
    }

    @Override
    protected TypeMirror returnType() {
        return this.componentMethod.resolvedReturnType(this.types);
    }

    @AssistedFactory
    static interface Factory {
        public ComponentMethodBindingExpression create(BindingExpression var1, ComponentDescriptor.ComponentMethodDescriptor var2);
    }
}

