/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import dagger.BindsInstance;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.binding.AutoValue_ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentCreatorAnnotation;
import dagger.internal.codegen.binding.ComponentCreatorKind;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.DependencyRequestFactory;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.DependencyRequest;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

@AutoValue
public abstract class ComponentCreatorDescriptor {
    public abstract ComponentCreatorAnnotation annotation();

    public final ComponentCreatorKind kind() {
        return this.annotation().creatorKind();
    }

    public abstract TypeElement typeElement();

    public abstract ExecutableElement factoryMethod();

    abstract ImmutableSetMultimap<ComponentRequirement, ExecutableElement> unvalidatedSetterMethods();

    abstract ImmutableSetMultimap<ComponentRequirement, VariableElement> unvalidatedFactoryParameters();

    public final ImmutableSetMultimap<ComponentRequirement, Element> unvalidatedRequirementElements() {
        return ImmutableSetMultimap.copyOf(this.unvalidatedSetterMethods().isEmpty() ? this.unvalidatedFactoryParameters() : this.unvalidatedSetterMethods());
    }

    ImmutableMap<ComponentRequirement, Element> requirementElements() {
        return ComponentCreatorDescriptor.flatten(this.unvalidatedRequirementElements());
    }

    public ImmutableMap<ComponentRequirement, ExecutableElement> setterMethods() {
        return ComponentCreatorDescriptor.flatten(this.unvalidatedSetterMethods());
    }

    public ImmutableMap<ComponentRequirement, VariableElement> factoryParameters() {
        return ComponentCreatorDescriptor.flatten(this.unvalidatedFactoryParameters());
    }

    private static <K, V> ImmutableMap<K, V> flatten(Multimap<K, V> multimap) {
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)multimap.asMap(), values -> Iterables.getOnlyElement((Iterable)values)));
    }

    public final ImmutableSet<ComponentRequirement> userSettableRequirements() {
        return this.unvalidatedRequirementElements().keySet();
    }

    public final ImmutableSet<ComponentRequirement> moduleAndDependencyRequirements() {
        return (ImmutableSet)this.userSettableRequirements().stream().filter(requirement -> !requirement.isBoundInstance()).collect(DaggerStreams.toImmutableSet());
    }

    final ImmutableSet<ComponentRequirement> boundInstanceRequirements() {
        return (ImmutableSet)this.userSettableRequirements().stream().filter(ComponentRequirement::isBoundInstance).collect(DaggerStreams.toImmutableSet());
    }

    final Element elementForRequirement(ComponentRequirement requirement) {
        return (Element)this.requirementElements().get((Object)requirement);
    }

    public static ComponentCreatorDescriptor create(DeclaredType type2, DaggerElements elements, DaggerTypes types, DependencyRequestFactory dependencyRequestFactory) {
        TypeElement typeElement2 = MoreTypes.asTypeElement(type2);
        TypeMirror componentType2 = typeElement2.getEnclosingElement().asType();
        ImmutableSetMultimap.Builder setterMethods = ImmutableSetMultimap.builder();
        ExecutableElement factoryMethod = null;
        for (ExecutableElement method : elements.getUnimplementedMethods(typeElement2)) {
            ExecutableType resolvedMethodType = MoreTypes.asExecutable(types.asMemberOf(type2, method));
            if (types.isSubtype(componentType2, resolvedMethodType.getReturnType())) {
                factoryMethod = method;
                continue;
            }
            VariableElement parameter = (VariableElement)Iterables.getOnlyElement(method.getParameters());
            TypeMirror parameterType = (TypeMirror)Iterables.getOnlyElement(resolvedMethodType.getParameterTypes());
            setterMethods.put((Object)ComponentCreatorDescriptor.requirement(method, parameter, parameterType, dependencyRequestFactory, method), (Object)method);
        }
        Verify.verify((factoryMethod != null ? 1 : 0) != 0);
        ImmutableSetMultimap.Builder factoryParameters = ImmutableSetMultimap.builder();
        ExecutableType resolvedFactoryMethodType = MoreTypes.asExecutable(types.asMemberOf(type2, factoryMethod));
        List<? extends VariableElement> parameters2 = factoryMethod.getParameters();
        List<? extends TypeMirror> parameterTypes2 = resolvedFactoryMethodType.getParameterTypes();
        for (int i = 0; i < parameters2.size(); ++i) {
            VariableElement parameter = parameters2.get(i);
            TypeMirror parameterType = parameterTypes2.get(i);
            factoryParameters.put((Object)ComponentCreatorDescriptor.requirement(factoryMethod, parameter, parameterType, dependencyRequestFactory, parameter), (Object)parameter);
        }
        ComponentCreatorAnnotation annotation = (ComponentCreatorAnnotation)((Object)Iterables.getOnlyElement(ComponentCreatorAnnotation.getCreatorAnnotations(typeElement2)));
        return new AutoValue_ComponentCreatorDescriptor(annotation, typeElement2, factoryMethod, (ImmutableSetMultimap<ComponentRequirement, ExecutableElement>)setterMethods.build(), (ImmutableSetMultimap<ComponentRequirement, VariableElement>)factoryParameters.build());
    }

    private static ComponentRequirement requirement(ExecutableElement method, VariableElement parameter, TypeMirror type2, DependencyRequestFactory dependencyRequestFactory, Element elementForVariableName) {
        if (MoreElements.isAnnotationPresent(method, BindsInstance.class) || MoreElements.isAnnotationPresent(parameter, BindsInstance.class)) {
            DependencyRequest request = dependencyRequestFactory.forRequiredResolvedVariable(parameter, type2);
            String variableName = elementForVariableName.getSimpleName().toString();
            return ComponentRequirement.forBoundInstance(request.key(), request.isNullable(), variableName);
        }
        return ModuleAnnotation.moduleAnnotation(MoreTypes.asTypeElement(type2)).isPresent() ? ComponentRequirement.forModule(type2) : ComponentRequirement.forDependency(type2);
    }
}

